/**
 * ArrayDemo
 * Illustrates using an array of Clickables
 * Copyright 2014 by James Brink
 * Revised date: 1/18/2014
 */

int NUM = 3;
Button[] btnArray = new Button[NUM+1];
CircleButton circleBtn = new CircleButton(25, 135, 7, "Circle Button",
                              #DDDDDD, #BBBBBB, #DD00DD, #BB00BB);
Clickable[] clickArray = new Clickable[NUM+1];
ClickableGroup clickGrp;

String msg;

void setup() {
  size(300, 160);
  smooth();
  frameRate(10);
  int i;
  for (i = 0; i < NUM; i++) {
    btnArray[i] = new Button(20, 40 + 25*i, 70, 20, "Button " + i,
                              #DDDDDD, #BBBBBB, #DD00DD, #BB00BB);
    clickArray[i] = btnArray[i];
  }
  clickArray[NUM] = circleBtn;
  clickGrp = new ClickableGroup(clickArray);                           
  msg = "Click a button";    
} // setup

void draw() {
  background(#FFFFAA);   // background color
  updateGrp();
  text("Array Demo", 120, 15);
  text(msg, 120, 100);
  clickGrp.display();
}  // draw

void updateGrp() {
  Clickable item;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    msg = "You clicked " + item.getLabel();
  }
} // updateGrp  

void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased

 
