/**
 * ButtonGroupDemo
 * Copyright 2014 by James Brink
 * Revised date: 1/22/2014
 */
Button btn1 = new Button(30, 40, 70, 30, "Button 1",
         #CCCCCC, #AAAAAA);
Button btn2 = new Button(30, 150, 70, 20, "Button 2", 
         #FFCCCC, #CCAAAA, #FFCCFF, #CCAACC);
CircleButton btn3 = new CircleButton(187, 47, 10, "Button 3", 
         #CCCCFF, #AAAACC, #CCFFCC, #AACCAA);
Checkbox btn4 = new Checkbox(180, 150, "Button 4");

Clickable[] clickArray = {btn1, btn2, btn3, btn4};
ClickableGroup clickGrp = new ClickableGroup(clickArray);

String msg;

void setup() {
  size(300, 210);
  smooth();
  frameRate(20);

  msg = "Click some buttons";
} // setup

void draw() {
  background(#FFFFAA);   // background color
  updateGrp();
  text("Button Group Demo", 110, 15);
  text(msg, 70, 195); 
  clickGrp.display();
}  // draw

void updateGrp() {
  Clickable item;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == btn1) {
      msg = "You clicked Button 1";
    } else if (item == btn2) {
      msg = "You clicked Button 2";
    } else if (item == btn3) {
      btn3.toggle();
      msg = "Button 3 is now selected: " + btn3.getSelected();
    } else if (item == btn4) {
      msg = "Button 4 is now selected: " + btn4.getSelected();
    }
  }
} // updateGrp  

void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased

 
