// A rewrite of the Buttons example by Casey Reas and Ben Fry.
// The rewrite uses the Clickable package by James Brink.
color currentcolor;

CircleButton circle1 = new CircleButton(30, 100, 50, "", 204, 153);
CircleButton circle2 = new CircleButton(130, 110, 12, "", 204, 153);
CircleButton circle3 = new CircleButton(130, 140, 12, "", 153, 102);
Button rect1 = new Button(150, 20, 50, 100, "", 102, 51);
Button rect2 = new Button(90, 20, 50, 50, "", 51, 0);

Clickable[] clickArray = {circle1, circle2, circle3, rect1, rect2};
ClickableGroup clickGrp = new ClickableGroup(clickArray);

void setup()
{
  size(200, 200);
  smooth();
  currentcolor = 102;
  circle1.setBorderColor(255);
  circle2.setBorderColor(255);
  circle3.setBorderColor(255);
  rect1.setBorderColor(255);
  rect2.setBorderColor(255);
}

void draw()
{
  background(currentcolor);
  stroke(255);
  updateGrp();  
  clickGrp.display(); 
}

void updateGrp() {
  Clickable item;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == circle1) {
      currentcolor = circle1.c[0];  //c[0] is the "normal" button color
    } else if (item == circle2) {
      currentcolor = circle2.c[0];
    } else if (item == circle3) {
      currentcolor = circle3.c[0];
    } else if (item == rect1) {
      currentcolor = rect1.c[0];
    } else if (item == rect2) {
      currentcolor = rect2.c[0];
    }
  }
}  

void mouseReleased() {
  clickGrp.checkForClick();
}   
  