/**
 * Checkbox Demo
 * Copyright 2014 by James Brink
 * Revised date: 1/13/2014
 */
Checkbox btn1 = new Checkbox(30, 70, "Click me");
Checkbox btn2 = new Checkbox(30, 110, 130, 30, "Hide 1st button",
                            #CCCCCC, #AAAAAA);
Clickable[] clickArray = {btn1, btn2};
ClickableGroup clickGrp = new ClickableGroup(clickArray);

int count;
void setup() {
  size(300, 210);
  smooth();
  frameRate(20);
} // setup

void draw() {
  background(#FFFFAA);   // background color
  updateGrp();
  
  fill(#000000);
  text("Checkbox Demo", 116, 15);
  text("1st Constructor", 30, 65);
  text("Selected: " + btn1.getSelected(), 180, 82);
  text("2nd constructor", 30, 105);
  text("Selected: " + btn2.getSelected(), 180, 120);
  clickGrp.display();
}  // draw

void updateGrp() {
  Clickable item;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == btn1) {
       // do something interesting
    } 
    if (item == btn2) {
      if (btn2.selected) {
        btn1.setVisible(false);
        btn2.setLabel("      Show 1st button");
      } else {
        btn1.setVisible(true);
        btn2.setLabel("      Hide 1st button");
      }
    }
  }
} // updateGrp  

void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased

 
