/**
 * CircleButtonDemo
 * Copyright 2014 by James Brink
 * Revised date: 1/22/2014
 */
color[] multiColors   // selected
      = {#FF00FF, #FF0000, #00DD00, #AAAAFF};
color[] overMultiColors
      = {#CC00CC, #FF0000, #00AA00, #8888CC};

CircleButton btn1 = new CircleButton(30, 57, 15, "Click to count",
         #CCCCCC, #AAAAAA);
CircleButton btn2 = new CircleButton(30, 115, 10, "Disable 1st button", 
         #FFEEEE, #CCBBBB, #FFCCFF, #CCAACC);
CircleButton btn3 = new CircleButton(30, 180, 20, "Change color state", 
         4, multiColors, overMultiColors);
Clickable[] clickArray = {btn1, btn2, btn3};
ClickableGroup clickGrp = new ClickableGroup(clickArray);

int count;
void setup() {
  size(300, 210);
  smooth();
  frameRate(20);

  count = 0;
} // setup

void draw() {
  background(#FFFFAA);   // background color
  updateGrp();
  text("CircleButton Demo", 100, 15);
  text("1st constructor", 20, 35);
  text("Count: " + count, 180, 55);
  text("2nd constructor", 20, 97);
  text("Selected: " + btn2.getSelected(), 180, 115);
  text("3rd constructor", 20, 155);
  text("State: " + btn3.getColorState(), 180, 175); 
  clickGrp.display();
}  // draw

void updateGrp() {
  Clickable item;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == btn1) {
      count++;
    } else if (item == btn2) {
      btn1.setEnabled(btn2.getSelected());
      btn2.toggle();
      if (btn2.getSelected())
        btn2.setLabel("Enable 1st button");
      else
        btn2.setLabel("Disable 1st button");
    } else if (item == btn3) {
      btn3.nextState();
    }
  }
} // updateGrp  

void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased

 
