/**
 * Demo for ScrollBars.
 * Copyright 2013-2014 by James Brink
 * Mar. 4, 2014
 * Permission is given for noncommercial use of this demo
 * as long as the copyright notice is retained.
 */

VertClickBar myClickBar = new VertClickBar(50, 40, 25, 172, "F Vertical ClickBar",
                                  #CCCCCC, #AAAAAA, #FF0000, 0.0, 68.0, 212.0);
HoriClickBar hClickBar = new HoriClickBar (130, 170, 250, 20, "C Horizontal ClickBar",
                                  #FFCCFF, #CCAACC, #FF0000, 100, 20, -17.7778);     
                                          // Max and min reversed to reverse scale                          
Clickable[] clickItems = {myClickBar, hClickBar};
ClickableGroup clickGrp = new ClickableGroup(clickItems);

void setup() {
  size(435, 270);
  myClickBar.showHashmarks(20);
  hClickBar.showLabels(50, 0);
  myClickBar.showValue();
  hClickBar.showValue();
} // setup

void draw() {
  background(#FFFFCC);
  smooth();

  updateClickGrp();
  
  fill(#FF0000);
  text("Scroll Bar Demo", 180, 25);
  text("Fahrenheit - Celcius conversion", 140, 65);

  fill(#0000FF);
  text("Fahrenheit", 34, 20);
  text("Celcius", 130, 125);
  text("(Reversed)", 130, 142); 
  fill(0);
  text(myClickBar.round2(myClickBar.getValue()) + " F", 50, 240);
  text(myClickBar.round2(hClickBar.getValue()) + " C", 130, 240);
  clickGrp.display();
}  // draw

void updateClickGrp() {
  Clickable item;
  float celcius;

  clickGrp.isOver();
  // check for clicks<a href="
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == myClickBar) {  // Fahrenheit
      celcius = 5.0 * (round(myClickBar.getValue()) - 32.0) / 9.0;
    } else if (item == hClickBar) {
      celcius = round(hClickBar.getValue());
    }else 
      return;
    myClickBar.setValue(9.0 * celcius / 5.0 + 32.0);
    hClickBar.setValue(celcius);
  }
}  // updateClickGrp

void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased

 
