/**
 * Demo for ClickBarSketch.  It shows how to setup up some
 * common Processing graphical methods so they can scroll.
 * A button is also created.  Nothing has to be done in order
 * make it scroll.
 *
 * This example illustrates how to set up a scrollable sketch.
 *
 * Copyright 2013-2014 by James Brink
 * Mar. 4, 2014
 * Permission is given for noncommercial use of this demo
 * as long as the copyright notice is retained.
 */
Button randomMoveBtn = new Button(50, 200, 120, 30, "Click to move button",
                                 #DDDDDD, #BBBBBB);
ScrollSketch sWin;
Clickable[] clickArray = {randomMoveBtn, sWin};
ClickableGroup clickGrp;

void setup() {
  size(300, 200);

  sWin = new ClickBarSketch(#E0E0E0, #C0C0C0, #0000FF);
  clickArray[1] = sWin;
  clickGrp = new ClickableGroup(clickArray);
  }  // setup 

void draw() {
  int offsetX, offsetY;
  background(#D0D0D0);
  smooth();
  updateClickableItems();
  fill(0);
  text("Scroll the window to see what is hidden.", sX_(20), sY_(30));
  fill(#FF0000);
  rect(sX_(200), sY_(40), 160, 100);
  fill(#0000FF);
  ellipse(sX_(230), sY_(200), 40, 60);
  fill(#00FF00);
  line(sX_(20), sY_(30), sX_(500), sY_(350));
  fill(#FFFF00);
  rect(sX_(400), sY_(200), 100, 75);
  clickGrp.display();
}  // draw

void updateClickableItems() {
  Clickable item;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == randomMoveBtn) {
      randomMoveBtn.x = randomMoveBtn.x + int(random(-25, 25));
      randomMoveBtn.y = randomMoveBtn.y + int(random(-25, 25));
    }
  }
}  // updateClickableItems

void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased
