/**
 * ClickableGroup Demo
 * Copyright 2014 by James Brink
 * Revised date: 3/26/2014
 */
// Strings arrays for ComboBoxes and the Menu
String[] cmb1Strings = {"Combo 1A", "Combo 1B", "Combo 1C"};
String[] cmb2Strings = {"Combo 2D", "Combo 2E", "Combo 2F"};
String[] menuStrings = {"Menu G", "Menu H", "Menu I", "Menu J"};
// The menu bar
MenuBar mnuBar = new MenuBar(#FFFFDD, #CCCCAA);
// Clickable items
Button btn = new Button(25, 75, 110, 150, "Big Button",
                 #DDDDDD, #AAAAAA, #DDDD00, #AAAA00);
ComboBox cmb1 = new ComboBox(25, 25, 90, cmb1Strings,
                 #DDDDDD, #AAAAAA, #DDDD00, #AAAA00);
ComboBox cmb2 = new ComboBox(25, 50, 90, cmb2Strings,
                 #DDDDDD, #AAAAAA, #DDDD00, #AAAA00);
Menu mnu = new Menu(100, "Menu item", menuStrings, mnuBar);                
ScrollSketch scrSketch = new ScrollSketch(480, 280, #FFDDFF, #CCAACC, #CCCCCC);
Clickable[] clickArray = {btn, cmb2, cmb1, mnuBar, mnu, scrSketch};
ClickableGroup clickGrp = new ClickableGroup(clickArray);
Clickable[] dragArray = {scrSketch};
Dragger dragGrp = new Dragger(dragArray);

// Output string
String msg;

void setup() {
  size(380, 200);
  smooth();
  frameRate(20);
  scrSketch.setupScrollSketch(true);
  msg = "Click some items";
}  // setup

void draw() {
  background(#FFFFAA);   // background color
  updateGrp();
  
  fill(#000000);
  text("ClickableGroup Demo", sX_(146), sY_(45));
  text(msg, sX_(146), sY_(75));
  
  clickGrp.display();
}  // draw

void updateGrp() {
  Clickable item;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item.getClickedItemNum() != Clickable.COMBO_BUTTON) {
      if (item == cmb1)
        msg = "You clicked " + cmb1.getSelectedItem().getLabel();
      else if (item == cmb2)
        msg = "You clicked " + cmb2.getSelectedItem().getLabel();
      else if (item == mnu) 
        msg = "You clicked " + mnu.getSelectedItem().getLabel();
      else
        msg = "You clicked " + item.getLabel();
    } else
      msg = "The button for drop down list \"" + item.getLabel() + "\" was clicked";
  }
}  // updateGrp

void mousePressed() {
  Draggable item;
  if (dragGrp.checkForDrag()) {
    item = (Draggable)dragGrp.getItemTracked();
    if (item == scrSketch) {
      scrSketch.readyForDrag(dragGrp);
    }
  }
}  // mousePressed

void mouseDragged() {
  Draggable item;
  if (mousePressed) {
    item = (Draggable)dragGrp.getItemTracked();
    if (item == scrSketch) {
      scrSketch.moved(dragGrp);
    }
  }
}  // mousePressed  

void mouseReleased() {
  if (dragGrp.getWasDragging())
    dragGrp.endDrag();
  else
    clickGrp.checkForClick();
}  // mouseReleased

