/**
 * Demo for ClickableMeter.
 * Copyright 2014 by James Brink
 * Mar.17, 2014
 * Permission is given for noncommercial use of this demo
 * as long as the copyright notice is retained.
 */

ClickableMeter vMeter = new ClickableMeter(50, 40, 25, 172, "F Vertical ScrollBar",
                                  #CCCCCC, #AAAAAA, #FF0000, 0.0, 68.0, 212.0);
ClickableMeter hMeter = new ClickableMeter (130, 170, 250, 20, "C Horizontal ScrollBar",
                                  #FFCCFF, #CCAACC, #0000FF, 100, 20, -17.7778);     
                                          // Max and min reversed to reverse scale                          
ClickableMeter outputVMeter = new ClickableMeter ( 440, 40, 20, 172, "Out C Vertical ScrollBar",
                                  #FFDDDD, #FFDDDD, #FF0000, 0.0, 68.0, 212.0);                                          
Clickable[] clickItems = {vMeter, hMeter};
ClickableGroup clickGrp = new ClickableGroup(clickItems);

void setup() {
  size(525, 270);
  vMeter.showHashmarks(20);
  hMeter.showLabels(50, 0);
  outputVMeter.showLabels(40);
  vMeter.showValue();
  hMeter.showValue();
} // setup

void draw() {
  background(#FFFFCC);
  smooth();

  updateClickGrp();
  
  fill(#FF0000);
  text("ClickableMeter Demo", 180, 25);
  text("Fahrenheit - Celcius conversion", 140, 65);

  fill(#0000FF);
  text("Fahrenheit", 34, 20);
  text("Celcius", 130, 125);
  text("(Reversed)", 130, 142); 
  text("Fahrenheit", 424, 20);
  text("(output only)", 421, 37);
  fill(0);
  text(round2_(vMeter.getValue()) + " F", 50, 240);
  text(round2_(hMeter.getValue()) + " C", 130, 240);
  outputVMeter.display();
  clickGrp.display();
}  // draw

void updateClickGrp() {
  Clickable item;
  float celcius;

  clickGrp.isOver();
  // check for clicks
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == vMeter) {  // Fahrenheit
      celcius = 5.0 * (round(vMeter.getValue()) - 32.0) / 9.0;
    } else if (item == hMeter) {
      celcius = round(hMeter.getValue());
    }else 
      return;
    vMeter.setValue(9.0 * celcius / 5.0 + 32.0);
    hMeter.setValue(celcius);
    outputVMeter.setValue(9.0 * celcius / 5.0 + 32.0);
  }
}  // updateClickGrp

void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased

 
