/**
 * ClickablePanel Demo
 * Copyright 2014 by James Brink
 * Revised date:  3/28/2014
 */
      
MyClickablePanel clickPnl = new MyClickablePanel(60, 40, 240, 90, 
     "Clickable Panel", #CCCCFF);
MyInvisiblePanel invisPnl = new MyInvisiblePanel(60, 130, 240, 30,
     "Secret Panel");
MyWholeSketchPanel sketchPnl = new MyWholeSketchPanel("Whole Sketch Panel");
   
Clickable[] clickArray = {sketchPnl, invisPnl, clickPnl};
ClickableGroup clickGrp = new ClickableGroup(clickArray);
String msg, msg2, msg3;

void setup() {
  size(360, 220);
  smooth();
  frameRate(20);
  
 // scrollWin = new ScrollSketch(#CCCCCC, #AAAAAA, #0000FF);
 // clickArray[3] = scrollWin;
 // clickGrp = new ClickableGroup(clickArray);
  sketchPnl.adjustPanel(false, false); // no menu, no scrollSketch
  msg = "";
  msg2 = "Click anywhere in the sketch and";
  msg3 = "see if you can find the secret panel.";
} // setup

void draw() {
  background(#FFFFAA);   // background color
  updateGrp();
  
  fill(#000000);
  text("ClickablePanel Demo", sX_(116), sY_(15));
  
  text(msg, 60, 155);
  text(msg2, 60, 175);
  text(msg3, 60, 195);
    
  clickGrp.display();
}  // draw

void updateGrp() {
  Clickable item;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == clickPnl) {
      if (clickPnl.getPanelX() < clickPnl.w/2) 
        msg = "You clicked the left half";
      else
        msg = "You clicked the right half";
      msg2 = "Clicked at absolute (" + clickPnl.getClickX() + ", " 
           + clickPnl.getClickY() + ")";
      msg3 = "Clicked at panel (" + clickPnl.getPanelX()
            + ", " + clickPnl.getPanelY() + ")";
    } else if (item == invisPnl) {
      msg = "";
      msg2 = "Congratulations.  You found the secret panel.";
      msg3 = "You clicked the panel at (" + invisPnl.getClickX() + ", " 
           + invisPnl.getClickY() + ")";
    } else if (item == sketchPnl) {
      msg = "";
      msg2 = "Sorry, you missed the secret panel.";
      msg3 = "You clicked the sketch at (" + sketchPnl.getClickX() + ", " 
           + sketchPnl.getClickY() + ")";
      clickPnl.setClickX(mouseX);
      clickPnl.setClickY(mouseY);
    }
  }
} // updateGrp  

void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased

// -------------------------------------------

/**
 * Extend ClickablePanel to draw on it.
 */
class MyClickablePanel extends ClickablePanel {
  MyClickablePanel(int leftX, int topY, int theWidth, int theHeight, String theLabel,
              color stdColor) {
    super(leftX, topY, theWidth, theHeight, theLabel, stdColor);
  }  // constructor MyClickablePanel
  
  void drawOnPanel() {
    if (getClickX() >= 0) {
      stroke(#FF0000);
      line(getClickX(), getClickY(), sX_(x), sY_(y));
      stroke(#008000);
      line(getClickX(), getClickY(), sX(x+w), sY_(y));
      stroke(#0000FF);
      line(getClickX(), getClickY(), sX(x), sY_(y+h));
      stroke(#FF00FF);
      line(getClickX(), getClickY(), sX(x+w), sY_(y+h));
    }
  }  // drawOnPanel
} // class MyClickablePanel

// -------------------------------------------

/**
 * Extend ClickablePanel invisibly.
 */
class MyInvisiblePanel extends ClickablePanel {
  MyInvisiblePanel(int leftX, int topY, int theWidth, int theHeight, String theLabel) {
    super(leftX, topY, theWidth, theHeight, theLabel);
  }  // constructor MyInvisblePanel
  
  void drawOnPanel() {
    if (getClickX() >= 0) {
      stroke(#FF0000);
      fill(#0000FF);
      ellipse (getClickX(), getClickY(), 15, 15);
    }
  }  // drawOnPanel
} // class MyInvisiblePanel

// -------------------------------------------

/**
 * Extend ClickablePanel to make the whole sketch an ivisible panel
 */
class MyWholeSketchPanel extends ClickablePanel {
  MyWholeSketchPanel(String theLabel) {
    super(theLabel);
  }  // constructor MyWholeSketchPanel
  
  void drawOnPanel() {
    if (getClickX() >= 0) {
      stroke(#00BB00);
      noFill();
      rect (getClickX() - 8, getClickY() - 8, 16, 16);
      fill(#FFFFFF);  // just eliminate noFill
    }
  }  // drawOnPanel
} // class MyWholeSketchPanel
