/**
 * ComboBox Demo
 * Copyright 2014 by James Brink
 * Revised date: 1/9/2014
 */
color[] colors  
      = {#FF00FF, #FF0000, #00A000, #0000FF};
color[] overColors
      = {#CC00CC, #CC0000, #008000, #0000CC};
color[] dimedColors 
      = {#FF80FF, #FF6060, #80A080, #8080FF};     
String[] colorNames
      = {"Cyan", "Red", "Green", "Blue"};

// Constructor 1
ComboBox comboBox1 = new ComboBox(20, 50, 60, colorNames,
         #CCCCCC, #AAAAAA, #CCCCAA, #AAAA88);
color c1;
// Constructor 2
Checkbox btn21 = new Checkbox(0, 0, "Red");
Checkbox btn22 = new Checkbox(0, 20, "Green");
Checkbox btn23 = new Checkbox(0, 40, "Blue");
Button[] array2 = {btn21, btn22, btn23};
ButtonGroup grp2 = new ButtonGroup(array2);
ComboBox comboBox2 = new ComboBox(180, 50, 60, 62, grp2,
         #CCCCCC, #AAAAAA, #CCCCAA, #AAAA88);
color c2;
Clickable[] clickArray = {comboBox1, comboBox2/*, comboBox3*/};
ClickableGroup clickGrp;

void setup() {
  size(300, 160);
  smooth();
  frameRate(20);
  
  c1 = colors[comboBox1.getSelectedItemNum()];
  c2 = #FF0000;
  // Complete the ClickableGroup
  clickGrp = new ClickableGroup(clickArray);
  comboBox2.setPermanentLabel("Color");
} // setup

void draw() {
  background(#FFFFAA);   // background color
  updateGrp();
  
  fill(#000000);
  text("ComboBox Demo", 116, 15);
  text("1st Constructor", 20, 45);
  text("2nd constructor", 180, 45);
  
  fill(c1);
  rect(25, 100, 50, 30);
  fill(c2);
  rect(185, 100, 50, 30);
  clickGrp.display();
  
}  // draw

void updateGrp() {
  Clickable item;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == comboBox1) {
      c1 = colors[comboBox1.getSelectedItemNum()];
    } 
    else if (item == comboBox2) {
      c2 = 0;
      if (btn21.getSelected()) 
        c2 += #FF0000;
      if (btn22.getSelected())
        c2 += #00FF00;
      if (btn23.getSelected())
        c2 += #0000FF;
    } 

  }
} // updateGrp  

void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased

 
