/**  
 * Draggable Demo
 * Copyright 2014 by James Brink
 * Revised date; 3/18/2014
 */
// ******************************************************* 
static final int SKETCH_HEIGHT = 300;
static final int SKETCH_WIDTH = 250;

Button btn = new Button(50, 70, 100, 30, "Drag me", #AAAAFF, #AAAACC);
ScrollBar sbNScroll = new ScrollBar(false, 20, 160, 195, 100, 200);
     // non scrollable scrollbar
ScrollBar sbScroll = new ScrollBar(false, 20, 240, 195, 100, 200);
     // scrollable scrollbar
ScrollSketch sSketch  = new ScrollSketch();
Clickable[] clickArray = {btn, sbNScroll, sbScroll, sSketch};
ClickableGroup clickGrp = new ClickableGroup(clickArray);
// all clickArray items can be dragged.
Dragger tracker = new Dragger(clickArray);

void setup() {
  size(SKETCH_WIDTH, SKETCH_HEIGHT);
  smooth();
  frameRate(20);
  sbNScroll.setScrollable(false);   // set sbNScroll Not to Scroll
  sSketch.setupScrollSketch(false);
} // setup

void draw() {
  int infoAreaY;
  color backgroundColor = #FFFFAA;
  background(backgroundColor);   // background color

  fill(#FF0000);
  rect(sX_(40), sY_(40), 450, 550);
  fill(#00FFFF);
  rect(sX_(100), sY_(180), 300, 400);
  fill(#90FF90);
  rect(sX_(200), sY_(200), 240, 290);
  stillSearching_ = true;
  fill(#000000);
  text ("Draggable Demo", sX_(10), sY_(17));
  text ("This ScrollBar is NOT scrolled.", 10, 140);
  text ("Value: " +round(sbNScroll.getValue()), 10, 157);
  text ("This ScrollBar is scrolled.", sX_(10), sY_(215));
  text ("Value: " + round(sbScroll.getValue()), sX_(10), sY_(232));
  clickGrp.display();
}  // draw

void mousePressed() {
  Clickable cItem;
  Draggable dItem;
  if (tracker.checkForDrag()) {
    cItem = tracker.getItemTracked();
    if (cItem == btn) {
      // Buttons and Clickable panels must be handled separately
      tracker.track(btn.getX(), btn.getY());
    } else {
      // This simplified approach for all the draggable
      // items are subclassed from Draggable.  Does not
      // work for Buttons or ClickablePanels.
      dItem = (Draggable)cItem;
      dItem.readyForDrag(tracker);
    }
  }
 }  // mousePressed
 
void mouseDragged() {
  Clickable cItem;
  Draggable dItem;
  
  if (!mousePressed){
    return;
  }
  cItem = tracker.getItemTracked();
  if (cItem == null)
    return;
  tracker.updateDrag();  // not required if only Draggable items
  if (cItem == btn) {
    btn.setY(tracker.getUpdatedY());
    btn.setX(tracker.getUpdatedX());
  } else {
    dItem = (Draggable)(tracker.getItemTracked());
        // or since we already have cItem
        // dItem = (Draggable)cItem;
    dItem.moved(tracker);
    tracker.updateDrag();
  }
} // mouseDragged

void mouseReleased() {
  if (tracker.getWasDragging())
    tracker.endDrag();
  else
    clickGrp.checkForClick();
}  // mouseReleased

