/**
 * DraggablePanel Demo
 * Copyright 2014 by James Brink
 * Revised date: 3/19/2014
 */

/* @pjs preload="data/FLOWER.PNG"; */

static final int SKETCH_WIDTH = 400;
static final int SKETCH_HEIGHT = 300; 

PImage flowerImg;     // Image to load

DraggablePanel dp1 = new DraggablePanel(50, 100, 100, 80, "Drag Panel", #00CC00);
DraggablePanel dp2 = new DraggablePanel(254, 50, 72, 78, "Flower Panel");
MyDraggablePanel mdp = new MyDraggablePanel(280, 180, 92, 98,
                             "Framed Pictured", #744A00);
Clickable[] clickArray = {dp1, mdp, dp2};
ClickableGroup clickGrp = new ClickableGroup(clickArray);

// all the elements in the clickArray can be dragged
Dragger tracker = new Dragger(clickArray); 

void setup() {
  size(SKETCH_WIDTH, SKETCH_HEIGHT);
  smooth();
  frameRate(20);
  
  flowerImg = loadImage("data/FLOWER.PNG");
  dp2.setProcessClicks(true);
} // setup

void draw() {
  int infoAreaY;
  color backgroundColor = #FFFFAA;
  background(backgroundColor);   // background color
  
  fill(#0000FF);
  text("DraggablePanel Demo", 140, 25);
  updateGrp();
  clickGrp.display();
  image(flowerImg, dp2.getX(), dp2.getY());  // covers invisible dp2
}  // draw

void updateGrp() {
  Clickable item;
  stillSearching_ = true;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == dp1) {
      dp1.x = 0;
      dp1.y = 0;
    }     
  }
} // updateGrp

void mousePressed() {
  DraggablePanel item;
  if (tracker.checkForDrag()) {
    item = (DraggablePanel)(tracker.getItemTracked());
    if (item != null)
      item.readyForDrag(tracker);
  }
}  // mousePressed
 
void mouseDragged() {
  DraggablePanel item;
  
  if (!mousePressed){
    return;
  }
  item = (DraggablePanel)(tracker.getItemTracked());
  if (item != null)
    item.moved(tracker);
} // mouseDragged

void mouseReleased() {
  if (tracker.getWasDragging())
    tracker.endDrag();
  else
    clickGrp.checkForClick();
}  // mouseReleased

// ****************************************************
/**
 * This class extends DraggablePanel to create a framed 
 * picture taking advantage of ClickablePanel's drawOnPanel()
 * method.
 */
class MyDraggablePanel extends DraggablePanel {
  
  /**
   * The required constructor
   */ 
  MyDraggablePanel(int leftX, int topY, int theWidth, int theHeight,
                  String theLabel, color stdColor)
  {
    super(leftX, topY, theWidth, theHeight, theLabel, stdColor);
  }  // constructor MyDraggablePanel
  
  /**
   * Draw the picture on top of the panel
   */
  void drawOnPanel() {
    image(flowerImg, x + 10, y + 10);
  }  // drawOnPanel
}  // class MyDraggablePanel
  
   
