/**
 * Dragable Demo
 * Copyright 2014 by James Brink
 * Revised date: 4/1/2014
 */
 // check box, ball, scrollbar, slider scrollpane
static final int SKETCH_WIDTH = 360;
static final int SKETCH_HEIGHT = 460;
 
Checkbox colorBtn = new Checkbox(300, 50, "Red");
CircleButton ballBtn = new CircleButton(100, 200, 30, "", #FFFF00, #CCCC00);
ScrollBar vScr = new ScrollBar(true, 20, 30, 220, SKETCH_HEIGHT, 0);
Slider hScr = new Slider(false, 60, 240, 290, 0, SKETCH_WIDTH);
ScrollPane pnl = new ScrollPane(10, 280, 340, 150, 20, 20,
                          #00FF00, #FFFF00, #000000,
                          0, 130, SKETCH_WIDTH,
                          0, 100, SKETCH_HEIGHT);
Clickable[] clickArray = {pnl, ballBtn, colorBtn, vScr, hScr};
ClickableGroup clickGrp = new ClickableGroup(clickArray);
Clickable[] dragArray = {pnl, ballBtn, vScr, hScr};
Dragger drag = new Dragger(dragArray);

void setup() {
  size(SKETCH_WIDTH, SKETCH_HEIGHT);
  smooth();
  frameRate(20);
  
  pnl.setProcessClicks(true);
  setBarsAndPanel();
} // setup

void draw() {
  background(#AAFFFF);   // background color
  updateGrp();
  
  clickGrp.display();
  text("ball x,y: (" + ballBtn.x + ", " + ballBtn.y + ")", 10, 300);
  text("ball getX: (" + ballBtn.getX() + ", " + ballBtn.getY() + ")", 10, 320);
}  // draw

void updateGrp() {
  Clickable item;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == colorBtn) {
      if (colorBtn.getSelected()) {
        ballBtn.c[0] = #FF0000;   // change to red
        ballBtn.overC[0] = #CC0000;
      } else {
        ballBtn.c[0] = #FFFF00;   // change to yellow
        ballBtn.overC[0] = #CCCC00;
      }
    } else if (item == pnl) {
      ballBtn.setY(pnl.getValueY());
      ballBtn.setX(pnl.getValueX());
      setBarsAndPanel();
    } else if (item == vScr) {
      ballBtn.setY(vScr.getValue());
      setBarsAndPanel();
    }
  }
} // updateGrp

void mousePressed() {
  Clickable cItem;
  Draggable dItem;
  
  if (drag.checkForDrag()) {
    cItem = drag.getItemTracked();
    if (cItem == ballBtn) {
      drag.track(ballBtn.getX(), ballBtn.getY()); 
    } else {
      dItem = (Draggable)cItem;
      dItem.readyForDrag(drag);
    }  
  }
}  // mousePressed
  
void mouseDragged() {
  Clickable cItem;
  Draggable dItem;
  cItem = drag.getItemTracked();
  drag.updateDrag();
  if (mousePressed) {
    if (cItem == ballBtn) {
      ballBtn.setY(drag.getUpdatedY());
      ballBtn.setX(drag.getUpdatedX());
    } else {
      dItem = (Draggable)cItem;
      dItem.moved(drag);
      if (dItem == vScr) {
        ballBtn.setY((int)(vScr.getValue()));
      } else if (dItem == hScr) {
        ballBtn.setX((int)(hScr.getValue()));
      } else if (dItem == pnl) {
        ballBtn.setX((int)(pnl.getValueX()));
        ballBtn.setY((int)(pnl.getValueY()));
      }
    }
    setBarsAndPanel();
  }
}  // mouseDragged    
      

void mouseReleased() {
  if (drag.getWasDragging())
    drag.endDrag();
  else
    clickGrp.checkForClick();
}  // mouseReleased

void setBarsAndPanel() {
  vScr.setValue(ballBtn.getY());
  hScr.setValue(ballBtn.getX());
  pnl.setValueY(ballBtn.getY());
  pnl.setValueX(ballBtn.getX());
}  // setBarsAndPanel