/**
 * DrawingMenu sketch:  Draws points, lines, triangles, and quadralaterals
 * with vertices clickecd by user.  
 * Testing ButtonGroup, ListBox, Menu
 *
 * James Brink
 * 3/26/14
 */

// vectors
color[] backColors
      = {#ADEAEA, #EAADEA, #FFFACD};
String[] backColorNames
      = {"Turquoise", "Plum", "LemonChiffon"};
color[] foreColors   // selected
      = {#FF00FF, #FF0000, #00DD00, #0000FF};
color[] foreColors0  // lineColor box normal
      = {#FF80FF, #FF7070, #80C080, #8080FF};
color[] foreColors1  // lineColor box over
      = {#CC30CC, #CC3030, #30A030, #3030C0};
color[] foreColors3  // linecolor box secected over
      = {#FF50FF, #FF5050, #30B030, #5050FF};
String[] foreColorNames
      = {"Cyan", "Red", "Green", "Blue"};
color[] fillColors
      = {#A0A0A0, #FF0000, #00C000, #0000FF, #000000};
String[] fillColorNames
      = {"Gray", "Red", "Green", "Blue", "Black"};
int[] shapes = {1, 2, 3, 4};
String[] shapeNames
      = {"Points", "Lines", "Triangles", "Quadrilaterals"};

//  Declare Drawing features
static final int NUM_SHAPES = 12;
Shape[] shp = new Shape[NUM_SHAPES];
int currentShape = shapes[0];
color lineColor = foreColors[0];
color pointColor = foreColors[0];
color backColor = backColors[0];
color fillColor = fillColors[0];
boolean filled = false;

// Declare clickable items
MyClickablePanel drawingPnl = new MyClickablePanel(20, 25, 320, 260,
                                     "Drawing Panel", backColor);
MenuBar mBar = new MenuBar(#CCCCCC, #CCDDDD);
Button clearMenuBtn = new Button(0, 0, 100, 20, "Clear", mBar.getColor(),
        mBar.getOverColor());
Checkbox fillMenuBtn = new Checkbox(0, 20, 100, 20, "Fill shape",
        mBar.getColor(), mBar.getOverColor());
Button[] optionsArray = {clearMenuBtn, fillMenuBtn};
ButtonGroup optionsBtnGrp = new ButtonGroup(optionsArray);
Menu optionsMenu = new Menu(75, 40, "Options", optionsBtnGrp, mBar);
Menu shapeMenu = new Menu(50, "Shape", 95, shapeNames, mBar, true);
Menu pointMenu = new Menu(75, "Point Color", foreColorNames, mBar);
Button[] lineMenuBtn = new Button[4];
ButtonGroup lineMenuGrp;
Menu lineMenu;
Menu fillMenu = new Menu(75, "Fill Color", fillColorNames, mBar);
Menu backMenu = new Menu(120, "Background Color", backColorNames, mBar);

// declare the clickArray.  At this point,
// backgroundColorCombo and lineColorListBox are
// null and must be reset in the setup method.  Then
// the clickGrp can be created.
Clickable[] clickArray = {drawingPnl,
           shapeMenu, pointMenu, lineMenu, fillMenu, backMenu, optionsMenu};
ClickableGroup clickGrp;

String msg;

/**
 *
 */
void setup() {
  size(500, 300);
  smooth();
  frameRate(20);
  int i;

  for (i = 1; i < shp.length; i++)
    shp[i] = null;
  shp[0] = new Shape(currentShape, pointColor, lineColor, fillColor,
                     filled, 4);

  for (i = 0; i < foreColors.length; i++)
    lineMenuBtn[i] = new Button(0, i * 20, 75, 20, foreColorNames[i],
                             mBar.getColor(), mBar.getOverColor(),
                             foreColors0[i], foreColors1[i]);
  lineMenuGrp = new ButtonGroup(lineMenuBtn);
  lineMenu = new Menu(75, 0, "Line Color", lineMenuGrp, mBar);
  // Now we can create the group
  clickArray[3] = lineMenu;
  clickGrp = new ClickableGroup(clickArray);

  // Set the introductory message
  msg = "Optionally change options on left and start clicking";
} // setup

void draw() {
  int i;
  background(#FFFFAA);   // background color
  fill(#000000);         // font (and other) color

  updateClickableItems();

  text(msg, 140, 395);

  fill(pointColor);
  text("Point color ", 350, 48);
  fill(lineColor);
  text("Line color ", 350, 68);
  fill(fillColor);
  text("Fill shapes: " + filled, 350, 88);
  fill(fillColor);
  text("Fill color ", 350, 108);
  fill(#000000);
  text("Shape: " + shapeNames[currentShape -1], 350, 128);
  mBar.display();
  clickGrp.display();
}  // draw

void updateClickableItems() {
  int itemNum;
  int i;
  ClickablePanel pnl;
  Clickable item;

  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    itemNum = clickGrp.getClickedItemNum();
    item = clickGrp.getClickedItem();
    if (item.getClickedItemNum() == Clickable.COMBO_BUTTON)
      return;
    msg = "Clicked " + itemNum + " selected " + clickGrp.getClickedItem().getSelectedItemLabel()
         + " " + clickGrp.getClickedItem().getSelectedItemNum();
    switch (itemNum) {
      case 0:  // drawing panel
        if (shp[0].isFull()) {
          for (i = shp.length - 1; i >= 1; i--)
            shp[i] = shp[i-1];
          shp[0] = new Shape(currentShape, pointColor, lineColor, fillColor,
                             filled, 4);
        }
        pnl = (ClickablePanel)clickGrp.getClickedItem();
        shp[0].addPt(pnl.getClickX(), pnl.getClickY());
        break;
      case 1:  // shape menu item
        currentShape = clickGrp.getClickedItem().getClickedItemNum() + 1;
        if (shp[0].getCurrentNumberPoints() == 0)
          shp[0].setShape(currentShape);
        break;
    }
    if (item.getClickedItemNum() != Clickable.COMBO_BUTTON) {
      if (item == pointMenu) {
        pointColor = foreColors[item.getClickedItemNum()];
        shp[0].setColors(pointColor, lineColor, fillColor);
      } else if (item == lineMenu) {
        lineColor = foreColors[item.getClickedItemNum()];
        shp[0].setColors(pointColor, lineColor, fillColor);
      } else if (item == fillMenu) {
        fillColor = fillColors[item.getClickedItemNum()];
        shp[0].setColors(pointColor, lineColor, fillColor);
      } else if (item == backMenu) {
        backColor = backColors[item.getClickedItemNum()];
        drawingPnl.setColor(backColor);
      } else if (item == optionsMenu) {
        if (item.getItem(item.getClickedItemNum()) == clearMenuBtn) {
          for (i = 1; i < NUM_SHAPES; i++)
            shp[i] = null;
          shp[0] = new Shape(currentShape, pointColor, lineColor, fillColor,
                             filled, 4);
        } else if (item.getItem(item.getClickedItemNum()) == fillMenuBtn) {
          filled = fillMenuBtn.getSelected();
          shp[0].setFilled(filled);
        }
      }
    }
  }
}  // updateClickableItems

void drawShapes () {
  int i;
  for (i = shp.length - 1; i >= 0; i--) {
    if (shp[i] != null) {
      shp[i].display();
    }
  }
}  // drawShapes

void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased

// *************************************************************

class Shape {
  static final int MAX_POINTS = 4;
  int numPoints;  // number of points in shape
  int num;  // num of points available
  color cPts, cLines, cFill;
  boolean filled;
  int rad;
  int[] x = new int[MAX_POINTS];
  int[] y = new int[MAX_POINTS];

  Shape(int numberPoints, color colorPoints, color colorLines, int colorFill,
        boolean fillIt, int radius)
  {
    numPoints = min(numberPoints, MAX_POINTS);
    cPts = colorPoints;
    cLines = colorLines;
    cFill = colorFill;
    filled = fillIt;
    rad = radius;
    num = 0;
  }  // constructor Shape

  void addPt(int xVal, int yVal) {
    if (num < numPoints) {
      x[num] = xVal;
      y[num] = yVal;
      num++;
    }
  }  // addPt

  boolean isFull() {
    return num >= numPoints;
  }  // is full

  void display() {
    int i;
    stroke(cPts);
    fill(pointColor);
    for (i = 0; i < num; i++) {
      ellipse(x[i], y[i], rad, rad);
    }
    stroke(cLines);
    if (filled && num >= 3){
      fill(cFill);
      if (num == 3)
        triangle(x[0], y[0],  x[1], y[1], x[2], y[2]);
      if (num == 4)
        quad(x[0], y[0],  x[1], y[1], x[2], y[2], x[3], y[3]);
    } else {
      for (i = 1; i < num; i++)
        line(x[i-1], y[i-1], x[i], y[i]);
      if (num == numPoints)
        line(x[0], y[0], x[num-1], y[num-1]);
    }
  }  // display

  void setColors(color ptColor, color lineColor, color fillColor) {
    cPts = ptColor;
    cLines = lineColor;
    cFill = fillColor;
  }  // setColors

  void setShape(int numberPoints) {
    numPoints = numberPoints;
  }  // setShape

  void setFilled(boolean fillIt) {
    filled = fillIt;
  }  // setFilled

  int getCurrentNumberPoints() {
    return num;
  } // getCurrentNumberPoints
}  // class Shape

// *************************************************************

/**
 * Extend ClickablePanel in order to include the drawing method
 */
class MyClickablePanel extends ClickablePanel {
  MyClickablePanel (int leftX, int topY, int theWidth, int theHeight,
                 String theLabel, color stdColor)
  {
    super(leftX, topY, theWidth, theHeight, theLabel, stdColor);
  }  // constructor MyClickablePanel

  void drawOnPanel() {
    drawShapes();
  }  // drawOnPanel

} // class MyClickablePanel