/**
 * ExampleVScrollBar and ExampleHScrollBar with demo
 * Copyright 2014 by James Brink
 * Revised date: 3/29/2014
 */
/**
 * This demo is designed to show how to create a new scrollbar
 * class.  They vertical and horizontal classes could be combined
 * into one by adding an orientation parameter and using the
 * select_(..,..,..) method when the arguments differ.
 */
class ExampleVScrollBar extends Scroller {
  static final int BAR_WIDTH = 30;
  static final int BAR_HEIGHT = 250;
  static final int BTN_HEIGHT = 20;
  
  ExampleVScrollBar(int leftX, int topY, float minValue, float maxValue) {
    super(true, leftX, topY, BAR_WIDTH, BAR_HEIGHT, "Example VScroll Bar",
          #8080FF, #FF0000, minValue, maxValue);
    scrollBtn = new Button(x, scrollBtnPos, w, 20, "", #FF0000, #CC0000);
    upBtn = new Button(x, y, w, BTN_HEIGHT, "   ^", #00FF00, #00CC00);
    downBtn = new Button(x, y + h - BTN_HEIGHT, w, BTN_HEIGHT, "   v",
           #00FF00, #00CC00);
    setScrollValues(); 
    setValue((2 * maxValue + minValue)/3);      
  } // constructor ExampleVScrollBar
} // class ExampleVScrollBar        

/* ------------------------------------------------------- */

class ExampleHScrollBar extends Scroller {
  static final int BAR_WIDTH = 250;
  static final int BAR_HEIGHT = 25;
  static final int BTN_WIDTH = 30;
  
  ExampleHScrollBar(int leftX, int topY, float minValue, float maxValue) {
    super(false, leftX, topY, BAR_WIDTH, BAR_HEIGHT, "Example HScroll Bar",
          #8080FF, #FF0000, minValue, maxValue);
    scrollBtn = new Button(scrollBtnPos, y, 20, BAR_HEIGHT, "", 
          #FF0000, #CC0000);
    upBtn = new Button(x, y, BTN_WIDTH, BAR_HEIGHT, " <", #00FF00, #00CC00);
    downBtn = new Button(x + w - BTN_WIDTH, y, BTN_WIDTH, BAR_HEIGHT, " >",
           #00FF00, #00CC00);
    setScrollValues(); 
    setValue((3 * maxValue + 2 * minValue)/5);      
  } // constructor ExampleHScrollBar
} // class ExampleHScrollBar        

/* ---------------------- The sketch --------------------- */

Checkbox reverseBtn = new Checkbox(140, 130, 148, 20, "Reverse min and max",
                  #CCCCCC, #BBBBBB);
ExampleVScrollBar expVBar = new ExampleVScrollBar(50, 40, 20.0, 50.0);
ExampleHScrollBar expHBar = new ExampleHScrollBar(140, 190, 40.0, 90.0);
Clickable[] clickArray = {reverseBtn, expVBar, expHBar};
ClickableGroup clickGrp = new ClickableGroup(clickArray);
Clickable[] dragArray = {expVBar, expHBar};
Dragger dragGrp = new Dragger(dragArray);

void setup() {
  size(420, 300);
  smooth();
  frameRate(15);
  
  expVBar.showLabels(5);
  expVBar.setSizes(40);
  expHBar.showHashmarks(10);
  expHBar.showValue();
}  // setup

void draw() {
  background(#CCCCFF);
  fill(#000000);
  updateGrp();
  text("Example ScrollBar Demo", 130, 20);
  text("Vertical Scroll Bar Value: " + round2_(expVBar.getValue()), 120, 100);
  text("Horizontal Scroll Bar Value: " + round2_(expHBar.getValue()), 180, 180);
  clickGrp.display();
}  // draw
 
void updateGrp() {
  // The Reverse min and max button and this method were added
  // just to show that the Exanmple Srcollbars worked when the
  // min and max's are reversed.
  Clickable item;
  float tempVVal, tempHVal;
  
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == reverseBtn) {
      tempVVal = expVBar.getValue();
      tempHVal = expHBar.getValue();
      if (reverseBtn.getSelected()) {
        expVBar.setMinValue(50.0);
        expVBar.setMaxValue(20.0);
        expHBar.setMinValue(90.0);
        expHBar.setMaxValue(40.0);
      } else {
        expVBar.setMinValue(20.0);
        expVBar.setMaxValue(50.0);
        expHBar.setMinValue(40.0);
        expHBar.setMaxValue(90.0);
      }
      expVBar.setSizes(30);
      expHBar.setSizes(20);
      expVBar.setValue(tempVVal);
      expHBar.setValue(tempHVal);
    }
  }
}
void mousePressed() {
  Draggable item;
  if (dragGrp.checkForDrag()) {
    item = (Draggable)dragGrp.getItemTracked();
    if (item != null) {
      item.readyForDrag(dragGrp);
    }
  }
}  // mousePressed
 
void mouseDragged() {
  Draggable item;
  if (!mousePressed) {
    return;
  }
  dragGrp.updateDrag();
  item = (Draggable)dragGrp.getItemTracked();
  if (item != null)
    item.moved(dragGrp);
} // mouseDragged

void mouseReleased() {
  if (dragGrp.getWasDragging())
    dragGrp.endDrag();
  else
    clickGrp.checkForClick();
}  // mouseReleased
