/**
 * ListBoxDemo
 * Copyright 2014 by James Brink
 * Revised date: 1/9/2014
 */
color[] colors  
      = {#FF00FF, #FF0000, #00A000, #0000FF};
color[] overColors
      = {#CC00CC, #CC0000, #008000, #0000CC};
color[] dimedColors 
      = {#FF80FF, #FF6060, #80A080, #8080FF};     
String[] colorNames
      = {"Cyan", "Red", "Green", "Blue"};

// Constructor 1
ListBox listBox1 = new ListBox(20, 50, 60, "ListBox 1", colorNames,
         #CCCCCC, #AAAAAA, #CCCCAA, #AAAA88);////
color c1;
// Constructor 2
Checkbox btn21 = new Checkbox(0, 0, "Red");
Checkbox btn22 = new Checkbox(0, 20, "Green");
Checkbox btn23 = new Checkbox(0, 40, "Blue");
Button[] array2 = {btn21, btn22, btn23};
ButtonGroup grp2 = new ButtonGroup(array2);
ListBox listBox2 = new ListBox(240, 50, "ListBox 2", grp2);
color c2;
// Constructor 3  (completed in setup())
CircleButton[] array3 = new CircleButton[colors.length];
ButtonGroup grp3;
ListBox listBox3;
color c3;

Clickable[] clickArray = {listBox1, listBox2, listBox3};
ClickableGroup clickGrp;

void setup() {
  size(350, 200);
  smooth();
  frameRate(20);
  
  c1 = colors[listBox1.getSelectedItemNum()];
  c2 = #FF0000;
  // Complete listBox3
  for (int i = 0; i < colors.length; i++) {
    array3[i] = new CircleButton(27, 20 * i + 11, 8, "",
                  dimedColors[i], dimedColors[i],
                  colors[i], overColors[i]);
  }
  array3[0].setSelected(true);
  grp3 = new ButtonGroup(array3);
  listBox3 = new ListBox(130, 50, 60, 84, #CCCCFF, "ListBox3", grp3);
  c3 = colors[listBox3.getSelectedItemNum()];
  clickArray[2] = listBox3;
  // Complete the ClickableGroup
  clickGrp = new ClickableGroup(clickArray);
} // setup

void draw() {
  background(#FFFFAA);   // background color
  updateGrp();
  
  fill(#000000);
  text("ListBox Demo", 141, 15);
  text("1st Constructor", 20, 45);
  text("3rd constructor", 130, 45);
  text("2nd constructor", 240, 45);
  
  fill(c1);
  rect(25, 150, 50, 30);
  fill(c3);
  rect(135, 150, 50, 30);
  fill(c2);
  rect(245, 150, 50, 30);
  clickGrp.display();
  
}  // draw

void updateGrp() {
  Clickable item;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == listBox1) {
      c1 = colors[listBox1.getSelectedItemNum()];
    } 
    else if (item == listBox2) {
      c2 = 0;
      if (btn21.getSelected()) 
        c2 += #FF0000;
      if (btn22.getSelected())
        c2 += #00FF00;
      if (btn23.getSelected())
        c2 += #0000FF;
    } else if (item == listBox3) {
      c3 = colors[listBox3.getSelectedItemNum()];
    } 

  }
} // updateGrp  

void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased

 
