/**
 * Menu Demo
 * Copyright 2014 by James Brink
 * Revised date: 3/26/2014
 */
color[] colors  
      = {#FF00FF, #FF0000, #00A000, #0000FF};
color[] overColors
      = {#CC00CC, #CC0000, #008000, #0000CC};
color[] dimedColors 
      = {#FF80FF, #FF6060, #80A080, #8080FF};     
String[] colorNames
      = {"Cyan", "Red", "Green", "Blue"};
      
MenuBar mBar = new MenuBar(#CCCCCC, #AAAAAA);

// Constructor 1
Menu menu1 = new Menu(80, "Color 1", colorNames,
         mBar);
color c1;
// Constructor 2
Menu menu2 = new Menu(60, "Color 2", 80, colorNames,
         mBar, true);
color c2;
// Constructor 3
Checkbox btn31 = new Checkbox(3, 2, "Red");
Checkbox btn32 = new Checkbox(3, 22, "Green");
Checkbox btn33 = new Checkbox(3, 42, "Blue");
Button[] array3 = {btn31, btn32, btn33};
ButtonGroup grp3 = new ButtonGroup(array3);
Menu menu3 = new Menu(80, 60, "Color 3", grp3, mBar);
color c3;

Clickable[] clickArray = {mBar, menu1, menu2, menu3};
ClickableGroup clickGrp;

void setup() {
  size(360, 160);
  smooth();
  frameRate(20);
    
  menu2.setSelectedItemNum(2);
  c1 = colors[menu1.getSelectedItemNum()];
  c2 = colors[menu2.getSelectedItemNum()];
  c3 = #FF0000;
  // Complete the ClickableGroup
  clickGrp = new ClickableGroup(clickArray);
} // setup

void draw() {
  background(#FFFFAA);   // background color
  updateGrp();
  
  fill(#000000);
  text("Menu Demo", 116, 15);
  text("1st Constructor", 20, 45);
  text("2nd Constructor", 140, 45);
  text("3rd Constructor", 260, 45);
  
  fill(c1);
  rect(25, 100, 50, 30);
  fill(c2);
  rect(145, 100, 50, 30);
  fill(c3);
  rect(265, 100, 50, 30);
 // mBar.display();
  clickGrp.display();
  
}  // draw

void updateGrp() {
  Clickable item;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == menu1) {
      c1 = colors[menu1.getSelectedItemNum()];
    } else if (item == menu2) {
      c2 = colors[menu2.getSelectedItemNum()];
    } else if (item == menu3) {
      c3 = 0;
      if (btn31.getSelected()) 
        c3 += #FF0000;
      if (btn32.getSelected())
        c3 += #00FF00;
      if (btn33.getSelected())
        c3 += #0000FF;
    } 

  }
} // updateGrp  

void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased

 
