/**
 * Demo for Meter and subclasses.
 * Copyright 2013-2014 by James Brink
 * Mar. 29, 2014
 * Permission is given for noncommercial use of this demo
 * as long as the copyright notice is retained.
 */
BarMeter vBar = new BarMeter(60, 40, 20, 172, "F Vertical BarMeter",
                             #CCCCCC, #EEEEEE, #00AA00, 0, 68, 212);
Thermometer myThermometer = new Thermometer(190, 40, 20, 172, "C Vertical Meter",
                                  #CCCCCC, #AAAAAA, #FF0000, -17.7778, 20, 100);
ClickableMeter myMeter = new ClickableMeter(340, 40, 15, 150, "K Vertical Meter",
                                  #FFCCCC, #EEBBBB, #000000, 255.3722, 293.15, 373.15);
ClickableMeter hMeter = new ClickableMeter(100, 295, 250, 30, "R Horizontal Meter",
                                  #CCFFCC, #BBEEBB, #000000, -14.222, 16, 80);
ClickableMeter myHMeter = new ClickableMeter(100, 365, 250, 20, "F Horizontal Meter",
                                  #EEEEEE, #CCCCCC, #00AA00, 212, 68, 0);
BarMeter hBar = new BarMeter(100, 435, 250, 15, "C Horizontal BarMeter",
                                  #CCFFFF, #AACCCC, #0000FF, -17.7778, 20, 100);

Clickable[] clickItems = {vBar, myThermometer, myMeter, hMeter, myHMeter, hBar};
ClickableGroup clickGrp = new ClickableGroup(clickItems);

void setup() {
  size(450, 500);
  vBar.showHashmarks(20);
  vBar.showLabels(212);
  myThermometer.showHashmarks(10, -10.);
  hMeter.showHashmarks(20., 0.);
  myThermometer.showLabels(20., 0);
  myMeter.showLabels(373.15 - 255.3722, 255.3722);
  hMeter.showLabels(40., 0.);
  myHMeter.showLabels(212);
  vBar.showValue();
  myMeter.showValue();
  hMeter.showValue();
  myHMeter.showValue();
  hBar.showValue();
} // setup

void draw() {
  background(#FFFFCC);
  smooth();

  updateClickGrp();

  fill(#0000FF);
  text("Fahrenheit", 34, 20);
  text("Celsius", 177, 20);
  text("Kelvin", 332, 20);
  text("Reaumur", 35, 315);
  text("Fahrenheit", 26, 380);
  text("(Reversed)", 26, 395); 
  text("Celcius", 45, 447);
  fill(0);
  text(round2_(vBar.getValue()) + " F", 50, 260);
  text(round2_(myThermometer.getValue()) + " C", 187, 260);
  text(round2_(myMeter.getValue()) + " K", 330, 260);
  text(round2_(hMeter.getValue()) + " R", 360, 315);
  text(round2_(myHMeter.getValue()) + " F", 360, 380);
  text(round2_(hBar.getValue()) + " C", 360, 447);

  clickGrp.display();
}  // draw

void updateClickGrp() {
  Clickable item;
  float celcius;
  
  celcius = 0;
  clickGrp.isOver();
  // check for clicks
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == vBar)  // Fahrenheit
      celcius = 5 * (vBar.getValue() - 32) / 9;
    else if (item == myThermometer) {  // Celsius
      celcius = myThermometer.getValue();
    } else if (item == myMeter) {  // Kelvin
      celcius = myMeter.getValue() - 273.15;
    } else if (item == hMeter) {  // Reaumur
      celcius = hMeter.getValue() * 1.25;
    } else if (item == myHMeter) {  // Fahrenheit
      celcius = 5 * (myHMeter.getValue() - 32) / 9;
    } else if (item == hBar) {
      celcius = hBar.getValue();
    }
    vBar.setValue(9 * celcius / 5 + 32);
    myThermometer.setValue(celcius);
    myMeter.setValue(celcius + 273.15);
    hMeter.setValue(celcius * .8);
    myHMeter.setValue(9 * celcius / 5 + 32);
    hBar.setValue(celcius);
  }
}  // updateClickGrp

void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased



