/**
 * NoGroup Demo
 * Copyright 2014 by James Brink
 * Revised date: 3/27/2014
 */
// Strings arrays for the ComboBox
String[] cmbStrings = {"Combo A", "Combo B", "Combo C"};
// Clickable items
Button btn = new Button(25, 55, 90, 30, "Button",
                 #DDDDDD, #AAAAAA, #DDDD00, #AAAA00);
ComboBox cmb = new ComboBox(25, 25, 90, cmbStrings,
                 #DDDDDD, #AAAAAA, #DDDD00, #AAAA00);
ScrollSketch scrSketch;
// Output string
String msg;

void setup() {
  size(320, 130);
  smooth();
  frameRate(20);
  msg = "Click some items";
}  // setup

void draw() {
  background(#FFFFAA);   // background color
  processAnyClicks();
  
  fill(#000000);
  text("NoGroup Demo", 146, 20);
  text(msg, 146, 75);
  btn.display();
  cmb.display();
}  // draw

void processAnyClicks() {
  if (btn.hasBeenClicked()) {
    msg = "The button was clicked";
  } else if (cmb.hasBeenClicked()) {
    if (cmb.getClickedItemNum() == Clickable.COMBO_BUTTON)
      msg = "The combo button was clicked"; 
    else
      msg = "You clicked " + cmb.getSelectedItem().getLabel();
  }
}  // processAnyClick

void mouseReleased() {
  stillSearching_ = true;
  cmb.hideSomething(); // close the dropdown list, if needed
  if (cmb.isOver())
    cmb.checkForClick();
  if (stillSearching_) {
    if (btn.isOver())
      btn.checkForClick();
  }
}  // mouseReleased