/**
 * RadioButton Demo
 * Copyright 2014 by James Brink
 * Revised date: 1/9/2014
 */
color[] multiColors   // selected
      = {#FF00FF, #FF0000, #00DD00, #AAAAFF};
color[] overMultiColors
      = {#CC00CC, #FF0000, #00AA00, #8888CC};

RadioButton btn1 = new RadioButton(30, 70, "Click me");
Clickable[] clickArray = {btn1};
ClickableGroup clickGrp = new ClickableGroup(clickArray);

int count;
void setup() {
  size(300, 150);
  smooth();
  frameRate(20);
} // setup

void draw() {
  background(#FFFFAA);   // background color
  updateGrp();
  text("RadioButton Demo", 116, 15);
  text("RadioButton", 30, 35);
  text("Selected: " + btn1.getSelected(), 180, 82);
  clickGrp.display();
}  // draw

void updateGrp() {
  Clickable item;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == btn1) {
       btn1.toggle();
    } 
  }
} // updateGrp  

void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased

 
