/**
 * RadioButtonListBoxDemo
 * Copyright 2014 by James Brink
 * Revised date: 1/22/2014
 */
color[] colors  
      = {#FF00FF, #FF0000, #00A000, #0000FF};
String[] colorNames
      = {"Cyan", "Red", "Green", "Blue"};

// Constructor 1
RadioButtonListBox radBtnListBox1 
   = new RadioButtonListBox(20, 50, 60, "RadioButtonListBox 1", colorNames,
         true, #CCCCCC);
color c1;
// Constructor 2  (completed in setup())
RadioButtonListBox radBtnListBox2 = new RadioButtonListBox(170, 50, 60, "RadioButtonListBox 1", colorNames,
         false, #CCCCCC);
color c2;

Clickable[] clickArray = {radBtnListBox1, radBtnListBox2};
ClickableGroup clickGrp = new ClickableGroup(clickArray);

void setup() {
  size(310, 200);
  smooth();
  frameRate(20);
  
  radBtnListBox2.setSelectedItemNum(1)
  c1 = colors[radBtnListBox1.getSelectedItemNum()];
  c2 =  colors[radBtnListBox2.getSelectedItemNum()];
} // setup

void draw() {
  background(#FFFFAA);   // background color
  updateGrp();
  
  fill(#000000);
  text("RadioButtonListBox Demo", 81, 15);
  text("Constructor with true", 20, 45);
  text("Constructor with false", 170, 45);
  
  fill(c1);
  rect(25, 150, 50, 30);
  fill(c2);
  rect(175, 150, 50, 30);
  clickGrp.display();
  
}  // draw

void updateGrp() {
  Clickable item;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == radBtnListBox1) {
      c1 = colors[radBtnListBox1.getSelectedItemNum()];
    } 
    else if (item == radBtnListBox2) {
      c2 = colors[radBtnListBox2.getSelectedItemNum()];
    } 

  }
} // updateGrp  

void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased

 
