/**
 * ScrollPane Demo
 * Copyright 2014 by James Brink
 * Revised date: 4/3/2014
 */
/* @pjs preload="data/FlowerLarge.jpg, data/FlowerThumb.jpg"; */

/* FlowerLargeImg is 1000 x 750.  Ratio width/height = .75
   FlowerThumbImg is 150 x 113
   Magnification is 1000/150 = 6.66667
   Display flower window is 240 x 180
   Cursor button is 240/6.66667 by 180/6.66667 = 36 x 27
   */

static final int SKETCH_WIDTH = 300;  // width of sketch
static final int SKETCH_HEIGHT = 390;   // height of sketch

static final int THUMB_IMG_W = 150;  // should agree with image width
static final int THUMB_IMG_H = 3 * THUMB_IMG_W/4;  // should agree with image height
static final int THUMB_IMG_X = (SKETCH_WIDTH - THUMB_IMG_W)/2;
static final int THUMB_IMG_Y = 230;  // flowerWindowY + flowerWindowH + 30
static final int SCROLL_BTN_WIDTH = 36;
static final int SCROLL_BTN_HEIGHT = 3 * SCROLL_BTN_WIDTH/4;

static final int FLOWER_WINDOW_W = 240;  // Width of flower window
static final int FLOWER_WINDOW_H = 3 * FLOWER_WINDOW_W/4;  // Its height
static final int FLOWER_WINDOW_X = (SKETCH_WIDTH - FLOWER_WINDOW_W)/2;  // Left side
static final int FLOWER_WINDOW_Y = 30;

static final int FLOWER_IMG_W = 1000;  // width of large flower image
static final int FLOWER_IMG_H = 750;  // hight of large flower image

static final int MIN_FLOWER_OFFSET_X = FLOWER_WINDOW_W - FLOWER_IMG_W;
static final int MIN_FLOWER_OFFSET_Y = FLOWER_WINDOW_H - FLOWER_IMG_H;
      // min of offsets from flower window to flower image
static final int MIN_FLOWER_X = MIN_FLOWER_OFFSET_X + FLOWER_WINDOW_X;                       
static final int MIN_FLOWER_Y = MIN_FLOWER_OFFSET_Y + FLOWER_WINDOW_Y;                               
      // minimum coordinates of upper left corner of flower image.

int flowerX, flowerY;

PImage flowerLargeImg, flowerThumbImg;         // Two images to load

ScrollPane flowerThumbJs = new ScrollPane(
          THUMB_IMG_X, THUMB_IMG_Y, THUMB_IMG_W, THUMB_IMG_H, 
          SCROLL_BTN_WIDTH, SCROLL_BTN_HEIGHT, 
          0x00CCCCCC, 0x60FFFFFF, 0xFF00FF00,  
          0.0, -305.0, MIN_FLOWER_OFFSET_X, 0.0, -225.0, MIN_FLOWER_OFFSET_Y);
         // fill thumnail and button colors set 00, ie, transparent but
         // border color is FF, ie. opaque
         // The values are set negative to move image to left and up.

Clickable[] clickArray = {flowerThumbJs};
ClickableGroup clickGrp = new ClickableGroup(clickArray);

Dragger tracker = new Dragger(clickArray);
   // Use same array for both clickGrp and tracker as there is only
   // one clickable object.

String msg, msg2, msg3;

void setup() {
  size(SKETCH_WIDTH, SKETCH_HEIGHT);
  smooth();
  frameRate(20);

  flowerLargeImg = loadImage("data/FlowerLarge.jpg");
  flowerThumbImg = loadImage("data/FlowerThumb.jpg");

  flowerX = (int)flowerThumbJs.getValueX();  // left side image display
  flowerY = (int)flowerThumbJs.getValueY();  // top image display
  flowerThumbJs.setProcessClicks(true);
/*
  println("SKETCH_WIDTH:  " + SKETCH_WIDTH
      + "\nSKETCH_HEIGHT: " + SKETCH_HEIGHT);
  println("THUMB_IMG_W: " + THUMB_IMG_W
      + "\nTHUMB_IMG_H: " + THUMB_IMG_H
      + "\nTHUMB_IMG_X: " + THUMB_IMG_X
      + "\nTHUMB_IMG_Y: " + THUMB_IMG_Y);
  println("SCROLL_BTN_WIDTH:  " + SCROLL_BTN_WIDTH
      + "\nSCROLL_BTN_HEIGHT: " + SCROLL_BTN_HEIGHT);
  println("FLOWER_WINDOW_W: " + FLOWER_WINDOW_W
      + "\nFLOWER_WINDOW_H: " + FLOWER_WINDOW_H
      + "\nFLOWER_WINDOW_X: " + FLOWER_WINDOW_X
      + "\nFLOWER_WINDOW_Y: " + FLOWER_WINDOW_Y);
  println("FLOWER_IMG_W: " + FLOWER_IMG_W
      + "\nFLOWER_IMG_H: " + FLOWER_IMG_H);
  println("MIN_FLOWER_OFFSET_X: " + MIN_FLOWER_OFFSET_X
      + "\nMIN_FLOWER_OFFSET_Y: " + MIN_FLOWER_OFFSET_Y);
  println("MIN_FLOWER_X: " + MIN_FLOWER_X                       
      + "\nMIN_FLOWER_Y: " + MIN_FLOWER_Y);  
  println("tracker.outsideLimit: " + tracker.outsideLimit);
  println("tracker.minForDrag: " + tracker.minForDrag);
*/  
} // setup

void draw() {
  color backgroundColor = #FFFFAA;
  background(backgroundColor);   // background color

  updateGrp();

  // draw the complete image
  image(flowerLargeImg, sX_(flowerX), sY_(flowerY));
  // draw the view window
  fill(backgroundColor);
  stroke(backgroundColor);
  rect(0, 0, width, FLOWER_WINDOW_Y);
  rect(0, FLOWER_WINDOW_Y, FLOWER_WINDOW_X, FLOWER_WINDOW_H);
  rect(FLOWER_WINDOW_X + FLOWER_WINDOW_W, FLOWER_WINDOW_Y, 
           FLOWER_WINDOW_X, FLOWER_WINDOW_H);
  rect(0, FLOWER_WINDOW_Y + FLOWER_WINDOW_H, width, 
           height - (FLOWER_WINDOW_Y + FLOWER_WINDOW_H));
  
  // show messages
  fill(#000000);
  if (mouseX >= 0)
    text("Cursor (" + mouseX + "," + mouseY + ")", sX_(2), sY_(363) );
  text("mousePressed: " + mousePressed + "   dragging: "
      + tracker.getDragging(), sX_(2), sY_(380));
  // draw the title
  fill(#0000FF);
  text("ScrollPane Demo", sX_(110), sY_(22));

  // draw the thumb nail and the mostly transparent joy stick on top of it
  image(flowerThumbImg, sX_(THUMB_IMG_X), sY_(THUMB_IMG_Y));
  clickGrp.display();
}  // draw

void updateGrp() {
  Clickable item;
  clickGrp.isOver();

  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == flowerThumbJs) {
      flowerX = (int)round(flowerThumbJs.getValueX() + FLOWER_WINDOW_X);
      flowerY = (int)round(flowerThumbJs.getValueY() + FLOWER_WINDOW_Y);
    } 
  }
} // updateGrp

void mousePressed() {
  Draggable item;
  if (tracker.checkForDrag()) {
    item = (Draggable)tracker.getItemTracked();
    if (item == flowerThumbJs) {
      if (flowerThumbJs.readyForDrag(tracker)) {
        tracker.setOutsideLimit(30);
      }
    }
  }
}  // mousePressed
  
void mouseDragged() {
  Draggable item;
  if (!mousePressed) {
    return;
  }
  tracker.updateDrag();
  item = (Draggable)tracker.getItemTracked();
  if (item == flowerThumbJs) {
    flowerThumbJs.moved(tracker);
    flowerX = (int)round(flowerThumbJs.getValueX() + FLOWER_WINDOW_X);
    flowerY = (int)round(flowerThumbJs.getValueY() + FLOWER_WINDOW_Y);
  }
} // mouseDragged

void mouseReleased() {
  if (tracker.getWasDragging())
    tracker.endDrag();
  else
    clickGrp.checkForClick();
}  // mouseReleased

