/**
 * Demo for ScrollSketch.  It shows how to setup up some
 * common Processing graphical methods so they can scroll.
 * A Button is also created. Nothing has to be done in order
 * make it scroll.
 *
 * Copyright 2013-2014 by James Brink
 * Apr. 3, 2014
 * Permission is given for noncommercial use of this demo
 * as long as the copyright notice is retained.
 */
Button randomMoveBtn = new Button(50, 200, 120, 30, "Click to move button",
                                 #DDDDDD, #BBBBBB);
ScrollSketch sWin = new ScrollSketch(#EEEEEE, #A0A0A0, #DDDDDD);
Clickable[] clickArray = {randomMoveBtn, sWin};
ClickableGroup clickGrp = new ClickableGroup(clickArray);
Clickable[] dragArray = {sWin};
Dragger drag = new Dragger(dragArray);

void setup() {
  size(300, 200);
  smooth();
  frameRate(15);

  sWin.setupScrollSketch(false);
  sWin.setProcessClicks(true);
}  // setup 

void draw() {
  int offsetX, offsetY;
  background(#D0D0D0);
  smooth();
  updateClickableItems();
  fill(0);
  text("Scroll the window to see what is hidden.", sX_(20), sY_(30));
  fill(#FF0000);
  rect(sX_(200), sY_(40), 160, 100);
  fill(#0000FF);
  ellipse(sX_(230), sY_(200), 40, 60);
  fill(#00FF00);
  line(sX_(20), sY_(30), sX_(500), sY_(350));
  fill(#FFFF00);
  rect(sX_(400), sY_(200), 100, 75);
  fill(0);
  clickGrp.display();
}  // draw

void updateClickableItems() {
  Clickable item;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == randomMoveBtn) {
      randomMoveBtn.x = randomMoveBtn.x + int(random(-25, 25));
      randomMoveBtn.y = randomMoveBtn.y + int(random(-25, 25));
    }
  }
}  // updateClickableItems

void mousePressed() {
  Draggable item;
  
  if (drag.checkForDrag()) {
    item = (Draggable)drag.getItemTracked();
    if (item != null) {
      item.readyForDrag(drag);
    }
  }
}  // mousePressed

void mouseDragged() {
  Draggable item;
  if (mousePressed) {
    drag.updateDrag();
    item = (Draggable)drag.getItemTracked();
    if (item != null) {
      item.moved(drag);
    }
  }
}  // mouseDragged

void mouseReleased() {
  if (drag.getWasDragging())
    drag.endDrag();
  else
    clickGrp.checkForClick();
}  // mouseReleased

