/**
 * Demo for ScrollSketch that also has a menu.  It shows how to setup
 * up some common Processing graphical methods so they can scroll.
 * Some Clickable and Draggable items are also created.  Nothing has 
 * to be done in order make them scroll.
 *
 * This example illustrates how to set up a scrollable sketch with a 
 * menubar.
 *
 * Copyright 2013-2014 by James Brink
 * Apr. 3, 2014
 * Permission is given for noncommercial use of this demo
 * as long as the copyright notice is retained.
 */
Button randomMoveBtn = new Button(50, 200, 120, 30, "Click to move button",
                                 #DDDDDD, #BBBBBB);
ScrollBar sBar = new ScrollBar(true, 20, 250, 100, 10, 20);
ScrollPane sPane = new ScrollPane(130, 240, 100, 60, 15, 15, 
                    #CCFFCC, #CCCCFF, #000000,
                    40, 60, 100, 20, 30, 50);
DraggablePanel dPnl = new DraggablePanel(250, 240, 100, 60, "Drag Panel",
                                        #00FFFF);
MenuBar theMenuBar = new MenuBar(#EECCCC, #BBAAAA);
String[] backgroundClrArray = {"Gray", "Light Blue", "Light Yellow"};
Menu backgroundClrMnu = new Menu(120, "Background color", backgroundClrArray,
                                 theMenuBar);
ScrollSketch sWin = new ScrollSketch(#EEEEEE, #A0A0A0, #DDDDDD);
Clickable[] clickArray = {randomMoveBtn, sBar, sPane, dPnl, theMenuBar,
                backgroundClrMnu, sWin};
ClickableGroup clickGrp = new ClickableGroup(clickArray);
Clickable[] dragArray = {sBar, sPane, dPnl, sWin};
Dragger drag = new Dragger(dragArray);

color bgClr;

void setup() {
  size(300, 200);
  smooth();
  frameRate(15);

  sWin.setupScrollSketch(true); // true - there is a menubar
  sWin.setProcessClicks(true);
  bgClr = #D0D0D0;
}  // setup 

void draw() {
  int offsetX, offsetY;
  background(bgClr);
  smooth();
  updateClickableItems();
  fill(0);
  text("Scroll the window to see what is hidden.", sX_(20), sY_(35));
  line(sX_(20), sY_(30), sX_(500), sY_(350));
  fill(#FF0000);
  rect(sX_(200), sY_(40), 160, 100);
  fill(#0000FF);
  ellipse(sX_(230), sY_(200), 40, 60);
  fill(#FFFF00);
  rect(sX_(400), sY_(200), 100, 75);
  fill(#000000);
  clickGrp.display();
}  // draw

void updateClickableItems() {
  Clickable item;
  int cl;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == randomMoveBtn) {
      randomMoveBtn.x = randomMoveBtn.x + int(random(-27, 25));
      randomMoveBtn.y = randomMoveBtn.y + int(random(-27, 25));
    } else if (item == backgroundClrMnu) {
        cl = backgroundClrMnu.getSelectedItemNum();
        if (cl == 0)  //  gray
          bgClr = #D0D0D0;
        else if (cl == 1)  // light blue
          bgClr = #DDDDFF;
        else // light yellow
          bgClr = #FFFFDD;
    }
  }
}  // updateClickableItems

void mousePressed() {
  Draggable item;
  if (drag.checkForDrag()) {
    item = (Draggable)(drag.getItemTracked());
    if (item != null) 
      item.readyForDrag(drag);
  }
}  // mousePressed

void mouseDragged() {
  Draggable item;
  if (mousePressed) {
    drag.updateDrag();
    item = (Draggable)(drag.getItemTracked());
    if (item != null) {
      item.moved(drag);
    }  
  }
}  // mouseDragged

void mouseReleased() {
  if (drag.getWasDragging())
    drag.endDrag();
  else
    clickGrp.checkForClick();
}  // mouseReleased

