// This version of Scrollbar uses the default SimpleScrollBar
// in the Clickable package written by James Brink
/* @pjs preload="data/seedTop.jpg, data/seedBottom.jpg"; */
int SKETCH_WIDTH = 200;
int SKETCH_HEIGHT = 200;
SimpleScrollBar hs1 = new SimpleScrollBar(false, 0, 20, SKETCH_WIDTH,
                              00, 400); 
SimpleScrollBar hs2 = new SimpleScrollBar(false, 0, 170, SKETCH_WIDTH, 
                              00, 400); 
Clickable[] clickArray = {hs1, hs2};
ClickableGroup clickGrp = new ClickableGroup(clickArray);
Dragger drag = new Dragger(clickArray);  

PImage top, bottom;         // Two image to load
int topWidth, bottomWidth;  // The width of the top and bottom images


void setup()
{
  size(SKETCH_WIDTH, SKETCH_HEIGHT);
  noStroke();
  hs1.setValue(200);
  hs2.setValue(200);

  drag.setOutsideLimit(70);

  top = loadImage("data/seedTop.jpg");
  topWidth = top.width;
  bottom = loadImage("data/seedBottom.jpg");
  bottomWidth = bottom.width;
}

void draw()
{
  background(255);
  
  // Get the position of the top scrollbar
  // and convert to a value to display the top image 
  float topPos = hs1.getValue()/2-width/2;
  fill(255);
  image(top, (width-topWidth)/2 + topPos*2, 0);
  
  // Get the position of the bottom scrollbar
  // and convert to a value to display the bottom image
  float bottomPos = hs2.getValue()/2-width/2;
  fill(255);
  image(bottom, (width-bottomWidth)/2 + bottomPos*2, height/2);

  clickGrp.display();
}

void mousePressed() {
  Draggable item;
  if (drag.checkForDrag()) {
    item = (Draggable)drag.getItemTracked();
    if (item != null) {
      item.readyForDrag(drag);
    }
  }
}

void mouseDragged() {
  Draggable item;
  if (!mousePressed) {
    return;
  }
  drag.updateDrag();
  item = (Draggable)drag.getItemTracked();
  if (item != null)
    item.moved(drag);
}

void mouseReleased() {
  if (drag.getWasDragging())
    drag.endDrag();
  else
    clickGrp.checkForClick();
}  // mouseReleased