/**
 * Scroller Demo #1
 * Copyright 2014 by James Brink
 * Revised date: 3/9/2014
 */
static final int SKETCH_WIDTH = 450;
static final int SKETCH_HEIGHT = 380;
ScrollBar hRedSBar = new ScrollBar(false, 10, 70, 200, 30,
                     30, "Red", #EEEEEE, #FF0000,
                     0, 255);
SimpleScrollBar hGreenSBar = new SimpleScrollBar(false, 10, 140, 200, 0, 255);

Slider hBlueSBar = new Slider(false, 10, 215, 200, 255, 0);
ScrollBar vRedSBar = new ScrollBar(true, 250, 70, 15, 200,
                     40, "Red", #CCCCCC, #FF8080,
                     0, 255);
SimpleScrollBar vGreenSBar = new SimpleScrollBar(true, 295, 70, 200, 0, 255);
Slider vBlueSBar = new Slider(true, 395, 70, 200, 255, 0);

Clickable[] clickArray = {hRedSBar, hGreenSBar, hBlueSBar, 
                          vRedSBar, vGreenSBar, vBlueSBar};
ClickableGroup clickGrp = new ClickableGroup(clickArray);

// All the Clickable items are also dragable.
Dragger tracker = new Dragger(clickArray);

int hR, hG, hB, vR, vG, vB;  

void setup() {
  size(SKETCH_WIDTH, SKETCH_HEIGHT);
  smooth();
  frameRate(20);
  
  hRedSBar.showLabels(64);
  hRedSBar.showHashmarks(32);
  hGreenSBar.showValue();
  hGreenSBar.setProcessClicks(true);
  hBlueSBar.showLabels(64);
  hBlueSBar.showValue();
  vGreenSBar.showLabels(64);
  vGreenSBar.showHashmarks(32);
  vBlueSBar.showHashmarks(32);
  vBlueSBar.showValue();
  vGreenSBar.setButtonFillColors(#00FF00, #00CC00);
  vBlueSBar.showLabels(255);
} // setup

void draw() {
  color backgroundColor = #FFFFAA;
  background(backgroundColor);   // background color
  fill(#0000FF);
  text("Scroller Demo", 190, 30);

  hR = (int)(hRedSBar.getValue());
  hG = (int)(hGreenSBar.getValue());
  hB = (int)(hBlueSBar.getValue());
  vR = (int)(vRedSBar.getValue());
  vG = (int)(vGreenSBar.getValue());
  vB = (int)(vBlueSBar.getValue());
  fill(#000000)
  text("Red", 10, 65);
  text("Green    (click or scroll)", 10, 135);
  text("Blue", 10, 195);
  text("Red", 250, 60);
  text("Green", 295, 60);
  text("Blue", 395, 60);
  fill(hR, hG, hB);
  text("Color(" + hR + ", " + hG + ", " + hB + ")", 70, 290);
  rect(70, 300, 70, 50);
  fill(vR, vG, vB);
  text("Color(" + vR + ", " + vG + ", " + vB + ")", 300, 290);
  rect(300, 300, 70, 50);
  clickGrp.display();
  hRedSBar.displayOneLabel(255, true);
  hBlueSBar.displayOneLabel(255, true);
  vGreenSBar.displayOneLabel(255, true);
}  // draw

void mousePressed() {
  Draggable item;
  if (tracker.checkForDrag()) {
    item = (Draggable)tracker.getItemTracked();
    if (item != null) {
      item.readyForDrag(tracker);
      if (item == vBlueSBar)
        tracker.setOutsideLimit(20);
    }
  }
}  // mousePressed
  
void mouseDragged() {
  Draggable item;
  if (!mousePressed) {
    return;
  }
  tracker.updateDrag();
  item = (Draggable)tracker.getItemTracked();
  if (item != null)
    item.moved(tracker);
} // mouseDragged

void mouseReleased() {
  if (tracker.getWasDragging())
    tracker.endDrag();
  else
    clickGrp.checkForClick();
}  // mouseReleased
