/**
 * Scroller Demo #2
 * Copyright 2014 by James Brink
 * Revised date: 3/4/2014
 */

static final int SKETCH_WIDTH = 400;  // width of sketch
static final int SKETCH_HEIGHT = 480;   // height of sketch
static final int COLOR_RECT_LEFT = 10;
static final int COLOR_RECT_TOP = 35;
static final int TEMP_RECT_LEFT = 10;
static final int TEMP_RECT_TOP = 180;
static final int BAR_RECT_LEFT = 295;
static final int BAR_RECT_TOP = 35;

// Color section
ScrollBar redBar = new ScrollBar(false,
          COLOR_RECT_LEFT + 10, COLOR_RECT_TOP + 15, 190, 0, 255);
ScrollBar greenBar = new ScrollBar(false,
          COLOR_RECT_LEFT + 10, COLOR_RECT_TOP + 45, 190, 0, 255);
ScrollBar blueBar = new ScrollBar(false,
          COLOR_RECT_LEFT + 10, COLOR_RECT_TOP + 75, 190, 0, 255);
// Temperature section    
ScrollBar FTempBar = new ScrollBar(true,
          TEMP_RECT_LEFT + 50, TEMP_RECT_TOP + 20, 30, 200,
          40, "F Temp Bar", #CCCCCC, #00FFFF,
          0.0, 212.0);
ScrollBar CTempBar = new ScrollBar(true,
          TEMP_RECT_LEFT + 170, TEMP_RECT_TOP + 20, 230, 100.0, -17.777778);
                                                           // reversed
// Bar section
ScrollBar minBar = new ScrollBar(false,
          BAR_RECT_LEFT + 10, BAR_RECT_TOP + 20, 200, 30, 
          15, "Minimum value Bar", #CCCCCC, #FF00FF, 0.0, 50.0);
ScrollBar maxBar = new ScrollBar(false,
          BAR_RECT_LEFT + 10, BAR_RECT_TOP + 100, 200, 100.0, 250.0);
Slider barSize = new Slider(true,
          BAR_RECT_LEFT + 235, BAR_RECT_TOP + 25, 150, 0, 100);
SimpleScrollBar barBar = new SimpleScrollBar(true,
          BAR_RECT_LEFT + 285, BAR_RECT_TOP + 25, 200, 50.0, 0.0);  // reversed        
// Last sectiom
SimpleScrollBar hSSBar = new SimpleScrollBar(false,
          315, 330, 250, 0.0, 10.0);          
Slider hSlider = new Slider(false,
          315, 405, 175, 200, 50);  // reversed

ScrollSketch sSketch = new ScrollSketch(700, 570, #EEEEEE, #AAAAAA, #CCCCCC);;
Clickable[] clickArray = {redBar, greenBar, blueBar, 
          FTempBar, CTempBar,
          minBar, maxBar, barSize, barBar,
          hSSBar, hSlider, 
          sSketch};
ClickableGroup clickGrp = new ClickableGroup(clickArray);

   // Use same array for both clickGrp and tracker as all Clickable items
   // are also draggable.
Dragger tracker = new Dragger(clickArray);

// Value variables
float valueRed, valueGreen, valueBlue, valueBarMin, valueBarMax, valueV1, valueV2,
      valueHS, valueHSlider, valueBarSize;

void setup() {
  size(SKETCH_WIDTH, SKETCH_HEIGHT);
  smooth();
  frameRate(20);
  int sliderSize;
  // setup scrollsketch
  sSketch.setupScrollSketch(false);

  // initialize bars and sliders
  valueRed = redBar.getValue();
  valueGreen = greenBar.getValue();
  valueBlue = blueBar.getValue();

  valueBarMin = minBar.getValue();
  valueBarMax = maxBar.getValue();
  valueHS = hSSBar.getValue(); 
  valueHSlider = hSlider.getValue();
  valueV1 = FTempBar.getValue();
  valueV2 = CTempBar.getValue(); 
  valueBarSize = barSize.getValue();
  // customize color bars
  redBar.setButtonFillColors(#FF0000, #BB0000);
  greenBar.setButtonFillColors(#00FF00, #00BB00);
  blueBar.setButtonFillColors(#0000FF, #0000BB);
  blueBar.showLabels(64);
  blueBar.showHashmarks(32);
  // customized temperature 
  FTempBar.showHashmarks(25);
  FTempBar.showLabels(50);
  FTempBar.showValue();
  CTempBar.showValue();
  CTempBar.showLabels(50, 0);
  // customize bar section
  minBar.showLabels(50);
  minBar.showValue();
  maxBar.showHashmarks(25);
  maxBar.showLabels(50);
  barSize.showHashmarks(25);
  barSize.showLabels(50);
  sliderSize = max(10,
       (int)(round(barBar.h * barSize.getValue()/barSize.getMaxValue())));
  barBar.setSizes(min(10, sliderSize));
  barBar.setMaxValue(minBar.getValue()); // barBar is reversed
  barBar.setMinValue(maxBar.getValue());
  barBar.showLabels(50);
  barBar.setValue(0);
  // customize other section
  hSlider.setBarColors(#000000, #808080);
  hSlider.showHashmarks(10);
  hSlider.showLabels(50);
  hSlider.showValue();
  hSlider.setButtonBorderColor(#008000);
  hSlider.setButtonFillColors(#00FF00, #00CC00);
} // setup

void draw() {
  int infoAreaY;
  color backgroundColor = #FFFFAA;
  background(backgroundColor);   // background color

  updateGrp();
  // show messages
  fill(#000000);
  // draw the title

  fill(#0000FF);
  text("ScrollBar Demo", sX_(230), sY_(22));
  // Color section
  fill(#000000);
  text("Color chooser", 
        sX_(COLOR_RECT_LEFT), sY_(COLOR_RECT_TOP - 5));
  fill(valueRed, valueGreen, valueBlue);
  rect(sX_(COLOR_RECT_LEFT), sY_(COLOR_RECT_TOP), 210, 120);
  fill(#FF0000);
  text("red:   " + valueRed, 
         sX_(COLOR_RECT_LEFT + 220), sY_(COLOR_RECT_TOP + 30));
  fill(#00FF00);
  text("green  " + valueGreen, 
         sX_(COLOR_RECT_LEFT + 220), sY_(COLOR_RECT_TOP + 60));
  fill(#0000FF);
  text("blue:  " + valueBlue, 
         sX_(COLOR_RECT_LEFT + 220), sY_(COLOR_RECT_TOP + 90));

  // temperature section
  fill(#000000);
  text("Temperature converter", 
        sX_(TEMP_RECT_LEFT), sY_(TEMP_RECT_TOP - 5));
  noFill();
  rect(sX_(10), sY_(180), 237, 300);
  fill(#000000);
  text("Fahrenheit: " + round2_(valueV1),
         sX_(TEMP_RECT_LEFT + 35), sY_(TEMP_RECT_TOP + 290));
  text("Reversed", sX_(TEMP_RECT_LEFT + 145), sY_(TEMP_RECT_TOP + 270));
          
  text("Celsius: " + round2_(valueV2),
         sX_(TEMP_RECT_LEFT + 145), sY_(TEMP_RECT_TOP + 290));

  // bar section
  fill(#000000);
  text("Variable bar section", 
     sX_(BAR_RECT_LEFT + 150), sY_(BAR_RECT_TOP - 5));
  noFill();
  rect(sX_(BAR_RECT_LEFT), sY_(BAR_RECT_TOP), 355, 275); 
  text("Minimum: " + round2_(valueBarMin),
            sX_(BAR_RECT_LEFT + 10), sY_(BAR_RECT_TOP + 85));
  text("Maximum: " + round2_(valueBarMax),
            sX_(BAR_RECT_LEFT + 10), sY_(BAR_RECT_TOP + 155));
  text("Scroll Button", sX_(BAR_RECT_LEFT + 205), sY_(BAR_RECT_TOP + 195));
  text("Size: " + round2_(valueBarSize) + "%",
                  sX_(BAR_RECT_LEFT + 205), sY_(BAR_RECT_TOP + 215));
  if (barBar.scrollBtnSize <= 10)
    text("Minimum = 10 pixels",
                  sX_(BAR_RECT_LEFT + 155), sY_(BAR_RECT_TOP + 235));
  text("Resulting", sX_(BAR_RECT_LEFT + 275), sY_(BAR_RECT_TOP + 245));
  text("Value: " + round2_(barBar.getValue()), 
                   sX_(BAR_RECT_LEFT + 275), sY_(BAR_RECT_TOP + 265));
  // other section: " 
  text("Value SimpleScrollBar: " + round2_(valueHS), sX_(315), sY_(370));
  text("Value Reversed Slider: " + round2_(valueHSlider), sX_(315), sY_(445));
  // display the bars
  clickGrp.display();

  blueBar.displayOneLabel(255, true);
  barBar.displayOneLabel(barBar.getMinValue(), true);
  barBar.displayOneLabel(barBar.getMaxValue(), true);
  // Debug info area
  infoAreaY = SKETCH_HEIGHT - 100;
  fill(#EEEEEE);
  rect(0, infoAreaY, SKETCH_WIDTH - 20, 80);
  fill(#000000);
  text("Tracker info:      dragging: " + tracker.getDragging() + 
       ", wasDragging: " + tracker.getWasDragging(), 10, infoAreaY + 17);
  text("outsideLimit: " 
        + tracker.outsideLimit + " minForDrag: " + tracker.minForDrag
        + ", traced list length: " +  tracker.draggableList.length,
        10, infoAreaY + 34);
  text("Point tracked (" + tracker.trackX + "," + tracker.trackY + ")"
       + ", Updated pointed (" + tracker.updatedX + "," + tracker.updatedY + ")"
       ,10, infoAreaY + 51);
//  if (tracker.itemTracked != null)     
//    text("item being tracked: " + tracker.itemTracked.getLabel(), 10, infoAreaY + 67);
}  // draw

void updateGrp() {
  Draggable item;
  stillSearching_ = true;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = (Draggable)clickGrp.getClickedItem();

    updateValues(item);
  }
} // updateGrp

void mousePressed() {
  Draggable item;
  if (tracker.checkForDrag()) {
    item = (Draggable)(tracker.getItemTracked());
    if (item == null)
      return;
    if (item == FTempBar) {
      if (FTempBar.readyForDrag(tracker)) {
        tracker.setOutsideLimit(40);
      } else if (minBar.readyForDrag(tracker)) {
        tracker.setOutsideLimit(20);
      }
    } else {
      item.readyForDrag(tracker);
    }
  }
}  // mousePressed
 
void mouseDragged() {
  Draggable item;
  if (!mousePressed){
    return;
  }
  item = (Draggable)(tracker.getItemTracked());
  if (item == null)
    return;
  item.moved(tracker);
  tracker.updateDrag();
  updateValues(item);
} // mouseDragged

void updateValues(Clickable item) {
  int sliderSize;
  // color section
  if (item == redBar) {
    valueRed = (int)(round(redBar.getValue()));
  } else if (item == greenBar) {
    valueGreen = (int)(round(greenBar.getValue()));
  } else if (item == blueBar) {
    valueBlue = (int)(round(blueBar.getValue()));
    // temperature section
  } else if (item == FTempBar) {
    valueV1 = (int)round(FTempBar.getValue());
    CTempBar.setValue(5.0 * (valueV1 - 32.0)/9.0);
    valueV2 = (int)round(CTempBar.getValue());
  } else if (item == CTempBar) {  
    valueV2 = (int)round(CTempBar.getValue());
    FTempBar.setValue(9.0 * valueV2/5.0 + 32.0);
    valueV1 = (int)round(FTempBar.getValue());
    // barBar section
  } else if (item == minBar) {
    valueBarMin = round2_(minBar.getValue());
    barBar.setMaxValue(valueBarMin);  // barBar is reversed
  } else if (item == maxBar) {  
    valueBarMax = round2_(maxBar.getValue());
    barBar.setMinValue(valueBarMax);
  } else if (item == barBar) {
    // displayed value taken from barBar when drawn.
    // valueBar = round2_(barBar.getValue());
  } else if (item == barSize) {
    valueBarSize = (int)round(barSize.getValue());
    sliderSize = 
       (int)(round(barBar.h * valueBarSize/barSize.getMaxValue()));
    barBar.setSizes(max(10, sliderSize));
    // other section
  } else if (item == hSSBar) {
    valueHS = (int)round(hSSBar.getValue());
  } else if (item == hSlider) {
    valueHSlider = (int)round(hSlider.getValue());
  } else if (item == sSketch) {
    // nothing needed
  }
}  // updateValues

void mouseReleased() {
  if (tracker.getWasDragging())
    tracker.endDrag();
  else
    clickGrp.checkForClick();
}  // mouseReleased

