/**
 * SimpleSwipePanelDemo
 * Copyright 2014 by James Brink
 * Revised date: 4/5/2014
 */

static final int SKETCH_WIDTH = 310;  // width of sketch
static final int SKETCH_HEIGHT = 315;   // height of sketch

SwipePanel swipePnl = new SwipePanel(10, 100, 290, 145,
           "Swipe Panel", 0x8000FFFF); 
Checkbox allowTapBtn = new Checkbox(20, 255, 120, 25, "Increment on tap",
                            #EEEEEE, #BBBBBB);
Checkbox tapThoughBtn = new Checkbox(170, 255, 120, 25, "Allow tap through", 
                            #EEEEEE, #BBBBBB);
RadioButton radioBtn = new RadioButton(95, 172, "Click me if you can");  
                              
Clickable[] clickArray = {radioBtn, swipePnl, allowTapBtn, tapThoughBtn};
ClickableGroup clickGrp = new ClickableGroup(clickArray);

void setup() {
  size(SKETCH_WIDTH, SKETCH_HEIGHT);
  smooth();
  frameRate(20);

  swipePnl.setXMax(10);  //Use defaults for current values and minimums 
  swipePnl.setYMax(10);
  swipePnl.setIncXOnTap(false);
  tapThoughBtn.setEnabled(false);
} // setup

void draw() {
  color backgroundColor = #FFFFAA;
  background(backgroundColor);   // background color

  updateGrp();
  fill(#000000);
  text("Simple Swipe Test", 100, 25);
  text("Current xVal: " + swipePnl.getXVal(), 50, 60);
  text("Current yVal: " + swipePnl.getYVal(), 180, 60);  
  text("Radio button selected: " + radioBtn.getSelected(), 80, 80);
  clickGrp.display();
}  // draw

void updateGrp() {
  Clickable item;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == allowTapBtn) {// check the tapButton
      swipePnl.setIncXOnTap(allowTapBtn.getSelected());
    } else if (item == tapThoughBtn) {
      swipePnl.setTapHole(tapThoughBtn.getSelected());
    } else if (item == radioBtn) {
      radioBtn.toggle();
    }
  } 
  tapThoughBtn.setEnabled(!allowTapBtn.getSelected());
  allowTapBtn.setEnabled(!tapThoughBtn.getSelected());
} // updateGrp

void mousePressed() {
  swipePnl.mouseDown();
 }  // mousePressed
 
void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased

