/**
 * SwipePanel Demo
 * Copyright 2014 by James Brink
 * Revised date: 3/28/2014
 */

static final int SKETCH_WIDTH = 410;  // width of sketch
static final int SKETCH_HEIGHT = 530;   // height of sketch

SwipePanel swipePnl = new SwipePanel(10, 310, 390, 145,
           "Swipe Panel", #00FFFF); 
Checkbox incOnTabBtn = new Checkbox(20, 465, 120, 25, "Increment on tap",
                            #EEEEEE, #BBBBBB);
Checkbox fullScreenBtn = new Checkbox(155, 465, 100, 25, "Full screen",
                            #EEEEEE, #BBBBBB);   
Checkbox allowTapThroughBtn = new Checkbox(270, 465, 120, 25, "Allow tap through", 
                            #EEEEEE, #BBBBBB);
Checkbox processClicksBtn = new Checkbox(270, 495, 120, 25, "Process clicks",
                            #EEEEEE, #BBBBBB); 
Checkbox showProcessDivBtn = new Checkbox(20, 495, 200, 25, 
                            "Show processClick regions",
                            #EEEEEE, #BBBBBB); 
                           
Button[][] btn = new Button[4][3];
       
Clickable[] clickArray = {null, null, null, null, null, null,
                          null, null, null, null, null, null,
                          swipePnl, allowTapThroughBtn, fullScreenBtn, incOnTabBtn,
                          processClicksBtn, showProcessDivBtn};
ClickableGroup clickGrp = new ClickableGroup(clickArray);

int row, col;
int numRows;

color selectedColor, titleColor;
boolean processClicks;

void setup() {
  size(SKETCH_WIDTH, SKETCH_HEIGHT);
  smooth();
  frameRate(20);
  int i, j;
  row = 1;
  col = 1;
  swipePnl.setXVal(row);
  swipePnl.setYVal(col);
  swipePnl.setXMax(8);
  swipePnl.setYMax(9);
  swipePnl.setXMin(1);
  swipePnl.setYMin(1);
  swipePnl.setMinSwipe(12);
  swipePnl.setIncXOnTap(false);
  for (i = 0; i < 4; i++)
    for (j = 0; j < 3; j++) {
      btn[i][j] = new Button(20 + 130 * j, 50 + 90 * i, 110, 70,
             "Button" + i + "" + j, 0x00FFFFFF, 0x00FFFFFF);
      if (i == 3)
        btn[i][j].setVisible(false);      
      clickArray[i * 3 + j] = btn[i][j]; 
  }
  numRows = 3;
  selectedColor = #FFFFFF;
  titleColor = #0000FF;  
  allowTapThroughBtn.setEnabled(false);
} // setup

void draw() {
  int i, j;
  color backgroundColor = #FFFFAA;
  background(backgroundColor);   // background color

  updateGrp();
  fill(selectedColor);
  rect(150, 5, 110, 30);
  fill(titleColor);
  text("Swipe Test", 170, 25);
  fill(#000000);
  col = swipePnl.getXVal();
  row = swipePnl.getYVal();
  for (i = row; i < row + numRows; i++)
    for (j = col; j <= col + 2; j++) {
      fill(271 - i * 32, 271 - j * 32, 0);
      rect(20 + 130 * (j - col), 50 + 90 * (i - row),110, 70, 5);
      fill(#000000);
      text("* Row " + i + " Col " + j + " *", 30 + 130 * (j - col),
                  70 + 90 * (i - row));
    }
  clickGrp.display();
  fill(#000000);
  text("Swipe this panel to change the above rows and columns", 30, 430);
  if (showProcessDivBtn.getSelected()) {
    stroke(#FF0000);
    line(swipePnl.x, swipePnl.y,
         swipePnl.x + swipePnl.w, swipePnl.y + swipePnl.h);
    line(swipePnl.x,  swipePnl.y + swipePnl.h,
         swipePnl.x + swipePnl.w, swipePnl.y);
    fill(#FF0000);
    text("Up ^", width/2 - 10, swipePnl.y + 62);
    text("Down v", width/2 - 20, swipePnl.y + swipePnl.h - 10);
    text("< Left ", 30, swipePnl.y + 6 * swipePnl.h/10);         
    text("Right >", width - 68, swipePnl.y + 6 * swipePnl.h/10);           
  }
}  // draw

void updateGrp() {
  Clickable item;
  int i, j;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == swipePnl) { // check swipePnl
      // it takes care of everything so nothing is necessary here
    } else if (item == processClicksBtn) {
      swipePnl.setProcessClicks(processClicksBtn.getSelected());
      setBtnEnables();
    } else if (item == incOnTabBtn) {
      swipePnl.setIncXOnTap(incOnTabBtn.getSelected());
      setBtnEnables();
    } else if (item == allowTapThroughBtn) { // check the tapThroughButton
      swipePnl.setTapHole(allowTapThroughBtn.getSelected());
      setBtnEnables();
    } else if (item == fullScreenBtn) {  // check the full screen button
      if (fullScreenBtn.getSelected()) {
        swipePnl.y = 40;
        swipePnl.h = 415;
        swipePnl.setColor(0x00FFFFFF);
        numRows = 4;
        for (j = 0; j < 3; j++)
          btn[3][j].setVisible(true);
      } else /* not selected */{
        swipePnl.y = 310;
        swipePnl.h = 145;
        swipePnl.setColor(#00FFFF);
        numRows = 3;
        for (j = 0; j < 3; j++)
          btn[3][j].setVisible(false);
        incOnTabBtn.setSelected(false);
        swipePnl.setTapHole(false);
      }
      setBtnEnables();
    } else {  // check btn array
      for (i = 0; i < 4; i++) {
        for (j = 0; j < 3; j++) {
          if (item == btn[i][j]) {
            selectedColor = color(271 - (i + row) * 32, 271 - (j + col) * 32, 0);
            if (i + row + j + col > 6)
              titleColor = #FFFFFF;
            else
              titleColor = #0000FF;  
          }
        }
      }
    }
  } 
} // updateGrp

void setBtnEnables() {
  if (processClicksBtn.getSelected()) {
    incOnTabBtn.setEnabled(false);
    allowTapThroughBtn.setEnabled(false);
  } else { // processClicksBtn is not selected
    if (fullScreenBtn.getSelected()) {
      incOnTabBtn.setEnabled(!allowTapThroughBtn.getSelected());
      allowTapThroughBtn.setEnabled(!incOnTabBtn.getSelected());
    } else {
      incOnTabBtn.setEnabled(true);
      allowTapThroughBtn.setEnabled(false);
    }
  } 
}  // setBtnEnables
void mousePressed() {
  swipePnl.mouseDown();
 }  // mousePressed
 
void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased

