/**
 * Demo for Thermometer.
 * Copyright 2014 by James Brink
 * Jan. 17, 2014
 * Permission is given for noncommercial use of this demo
 * as long as the copyright notice is retained.
 */

Thermometer vMeter = new Thermometer(50, 50, 25, 172, "F Vertical ScrollBar",
                                  #CCCCCC, #AAAAAA, #FF0000, 0.0, 68.0, 212.0);
Thermometer outputVMeter = new Thermometer ( 380, 50, 20, 172, "Out C Vertical ScrollBar",
                                  #FFDDDD, #FFDDDD, #FF0000, -17.7778, 20, 100);                                          
Clickable[] clickItems = {vMeter};
ClickableGroup clickGrp = new ClickableGroup(clickItems);

void setup() {
  size(525, 270);
  vMeter.showHashmarks(20);
  outputVMeter.showLabels(20, 0);
  vMeter.showValue();
} // setup

void draw() {
  background(#FFFFCC);
  smooth();

  updateClickGrp();
  
  fill(#FF0000);
  text("Thermometer Demo", 168, 25);
  text("Fahrenheit - Celcius conversion", 140, 65);
  fill(#000000);
  text(vMeter.getValue() + " F equals " + round2_(outputVMeter.getValue())
           + " C", 170, 130);

  fill(#0000FF);
  text("Fahrenheit", 34, 20);
   text("Celcius", 374, 20);
  text("(output only)", 361, 37);
  fill(0);
  text(round2_(vMeter.getValue()) + " F", 50, 240);
  outputVMeter.display();
  clickGrp.display();
}  // draw

void updateClickGrp() {
  Clickable item;
  float celcius;

  clickGrp.isOver();
  // check for clicks
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == vMeter) {  // Fahrenheit
      celcius = 5.0 * (round(vMeter.getValue()) - 32.0) / 9.0;
    }else 
      return;
    vMeter.setValue(9.0 * celcius / 5.0 + 32.0);
    outputVMeter.setValue(celcius);
  }
}  // updateClickGrp

void mouseReleased() {
  clickGrp.checkForClick();
}  // mouseReleased

 
