/**
 * Simple demo of a few Clickable objects
 *
 * James Brink
 * Mar. 26, 2014
 */

// other variables
boolean happy;
boolean female;
boolean movingHands;
boolean movingUp;
float angle;
color backColor, skirtColor, topColor;
int hemline;
// some useful strings and colors
String[] modeStr = {"Happy", "Sad"};
color[] backColors
      = {#ADEAEA, #EAADEA, #FFFACD};
String[] backColorNames
      = {"Turquoise", "Plum", "LemonChiffon"};
color[] colors = {#FF0000, #00FF00, #0000FF,
                  #00FFFF, #FF00FF, #FFFF00};
String[] colorNames = {"Red", "Green", "Blue", 
                       "Aqua", "Fuchsia", "Yellow"};
color[] overColors = {#FFAAAA, #AAFFAA, #AAAAFF,
                      #AAFFFF, #FFAAFF, #FFFFAA};


// the Clickables
MenuBar myMenuBar = new MenuBar(#AAAAFF, #8080CC);
Menu backColorMenu = new Menu(130, "Background Color",
                   backColorNames, myMenuBar);
Button moveArmBtn = new Button(20, 28, 120, 20, "Move Arms",
           #CCCCCC, #AAAAAA);
RadioButtonListBox modeListBox = new RadioButtonListBox(20, 53, 120, "Happy Mode list",
          modeStr, true, #BBCCCC);
Checkbox femaleBtn = new Checkbox(24, 98, "Female");
CircleButton topColorBtn = new CircleButton(30, 125, 10, "Female's Top Color",
                      3, colors, overColors);         
ComboBox skirtColorCmb = new ComboBox(20, 153, 120, colorNames,
                               #CCCCCC, #AAAAAA, #FFCCCC, #CCAAAA);
ScrollBar hemlineScr = new ScrollBar(true, 115, 185, 20, 105, 20,
                              "Hemline ScrollBar", #CCCCCC, #FF00FF,
                               230, 185);  // scrollbar is upside down
// the Clickable group
Clickable[] clickGrpArray = {moveArmBtn, femaleBtn, modeListBox, 
                            topColorBtn, hemlineScr, skirtColorCmb,
                            myMenuBar, backColorMenu}; 
ClickableGroup clickGrp = new ClickableGroup(clickGrpArray);
Draggable[] dragGrpArray = {hemlineScr};
Dragger dragGrp = new Dragger(dragGrpArray); 


void setup() {
  // initialize
  size(350, 300);
  
  happy = true;
  female =  false;
  backColor = backColors[0];
  skirtColor = colors[0];
  topColor = colors[0];
  movingHands = false;
  angle = 0;  // initial angle of arms
  hemline = 185;
} // setup

void draw() {
  // draw the sketch
  background(backColor);   // background color
  fill(0);
  text("Female's skirt color", 20, 150);
  text("Use scrollbar", 20, 195);
  text("to adjust her", 20, 211);
  text("hemline", 20, 227);
  updateClickable();
  clickGrp.display();
  drawPerson();
}  // draw

void updateClickable() {
  // check actions of the Clickable items in the clickGrp
  Clickable item;
  clickGrp.isOver();
  if (clickGrp.hasBeenClicked()) {
    item = clickGrp.getClickedItem();
    if (item == femaleBtn) {
      female = femaleBtn.getSelected();
    } else if (item == modeListBox) {
      happy = modeListBox.getSelectedItemNum() == 0;
    } else if (item == backColorMenu) {
      backColor = backColors[backColorMenu.getSelectedItemNum()];
    } else if (item == moveArmBtn) {
      movingHands = true;  
      movingUp = true;    
    } else if (item == topColorBtn) {
      topColorBtn.nextState();
      topColor = colors[topColorBtn.getColorState()];
    } else if (item == skirtColorCmb) {
      skirtColor = colors[skirtColorCmb.getSelectedItemNum()];
    } else if (item == hemlineScr) {
      hemline = (int)(hemlineScr.getValue());
    }
  }
}
  
void drawPerson() {
  // draw the person
  final int midX = 240;
  final int topY = 70;
  final int bottomY = 140;
  
  int handX, handY, flair;
 
  if (female) {
    fill(#808000);
    arc (midX, topY-15, 40, 40, -PI, 0); // hair
    rect(midX-20, topY-15, 40, 15);      // more hair
  }

  fill(255);
  ellipse (midX, topY-15, 30, 30);  // head
  ellipse (midX-5, topY-20, 5, 5);  // left eye
  ellipse (midX+5, topY-20, 5, 5);  // right eye
  if (happy)
    arc (midX, topY-15, 20, 20, PI/2-.6, PI/2+.6); // lips
  else
    arc (midX, topY+2, 20, 20, -PI/2-.6, -PI/2+.6);
  line (midX, topY, midX, bottomY); // body
  line (midX-30, topY+10, midX+30, topY+10);  // shoulders
  line (midX-30, topY+10, midX-20, topY+40);  // left upper arm
  line (midX+30, topY+10, midX+40, topY+40);  // right upper arm
  line (midX, bottomY, midX-30, bottomY+45);  // left upper leg
  line (midX, bottomY, midX+30, bottomY+45);  // right upper leg
  line (midX-30, bottomY+45, midX-30, bottomY+90); // left lower leg
  line (midX+30, bottomY+45, midX+30, bottomY+90); // left lower leg
  line (midX-30, bottomY+90, midX-40, bottomY+90); // left foot
  line (midX+30, bottomY+90, midX+20, bottomY+90); // right foot
  // draw top and skirt for female
  if (female) {
    fill(topColor);
    triangle(midX-30, topY+5, midX+30, topY+5, midX, bottomY);
    fill(skirtColor);
    stroke(skirtColor);
    triangle(midX, bottomY-5, midX-35, bottomY+45, midX+35, bottomY+45);
    flair = (int)(10.0 * (hemline-bottomY-50.0)/45.0);
    if (hemline > bottomY+45)
      quad(midX-35, bottomY+45, midX+35, bottomY+45,
           midX+35+flair, hemline, midX-35-flair, hemline);
    fill(#808000);
    stroke(0);
    
  }
  // move hands if requested and draw them
  if (movingHands) {
    if (movingUp){
      angle += 1.0/20.0; 
      if (angle > 3 * PI/4) {
        movingUp = false;
      }
    } else 
      angle -= 1.0/20.0 ; 
      if (angle < 0) {
        movingHands = false;
      }
  }
  handY = (int)(30 * sin(angle) + topY+40);
  handX = (int)(30 * cos(angle));
      
  line (midX-20, topY+40, midX-20-handX, handY);  // left lower arm
  line (midX+40, topY+40, midX+40-handX, handY);  // right lower arm

}  //drawPerson
  
void mousePressed() {
  Draggable item;
  if (dragGrp.checkForDrag()) {
    item = (Draggable)dragGrp.getItemTracked();
    if (item != null) {
      item.readyForDrag(dragGrp);
    }
  }
}  // mousePressed

void mouseDragged() {
  Draggable item;
  if (!mousePressed) {
    return;
  }
  dragGrp.updateDrag();
  item = (Draggable)dragGrp.getItemTracked();
  if (item == hemlineScr) {
    hemlineScr.moved(dragGrp);
    hemline = (int)(hemlineScr.getValue());
  }
} // mouseDragged

    
    
void mouseReleased() {
  if (dragGrp.getWasDragging())
    dragGrp.endDrag();
  else
    clickGrp.checkForClick();
}  // mouseReleased



