<!DOCTYPE HTML>
<html lang="en">
<head>

  <title>CanvasClass</title>
  <meta charset="UTF-8" >
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="description" content="p5js CanvasClass reference.">
  <meta name="keywords" content="p5js, CanvasClass, reference ">
  <meta name="ROBOTS" content="INDEX, FOLLOW">
   <style>
   body {width: 800px; background-color: silver;}
    h1 {text-align: center; color: blue;}
  </style>
  <script src="http://www.brinkje.com/p5js/p5.min.js"></script>
  <script src="CanvasClass.pjs"></script>
</head>
<body>
<h1>CanvasClass</h1>
<p>I started using p5.js in December, 2019.  I wanted to have two canvases for
  my first significant application and was 
  really disappointed to read "Calling
  createCanvas more than once in a sketch will result in very unpredictable
  behavior."  Because that has not a HTML or Javascript restriction, I decided
  to see if there was away around this problem.  My first effort was 
  semi-successful but required a lot of coding.  Then I learned about 
  instance mode which supposedly solves the problem but in my experience
  seems to be mystical and makes it difficult to use events.</p>
<p>I started over again and came up with <tt>CanvasClass</tt> (for the 
  lack of a better name).  As the name suggests, it declares a CanvasClass
  class.  I think it enables users to
  avoid the problems with instance mode.  Most of the p5.js 
  methods (except for some WEBGL methods when used "in motion")
  and events for the canvas work.
  Over 110 functions are believed to work with over a dozen additional
  ones that work in part. </p>
<p>Here is a very simple example that uses two canvases and demonstrates
  the type of coding needed.  Notice that one has to name each canvas and use the
  name whenever referring to the canvas or the mouse. Drag your mouse over
  the two
  canvases and click on the first one.  You will notice that the events and
  mouse values only work when the mouse is over the canvas.</p>
<table>
  <tr><td>
<pre>let canvas1, canvas2, backgroundColor1;
function setup() {
  canvas1 = createCanvasClass(180, 170);
  canvas1.parent("Example");
  canvas1.fill(255, 0, 0);
  canvas1.mouseClicked(clicked);
  backgroundColor1 = "FloralWhite";
  canvas2 = createCanvasClass(150, 200);
  canvas2.parent("Example");
  canvas2.stroke(255, 0, 255);
}
function draw() {
  canvas1.background(backgroundColor1);
  canvas1.rect(canvas1.mouseX, canvas1.mouseY, 100 ,80);
  canvas2.background("Khaki");
  canvas2.line(canvas2.mouseX, canvas2.mouseY, 75, 100);
}
function clicked() {
  if (backgroundColor1 == "FloralWhite") {
    backgroundColor1 = "LightCyan";
  } else {
    backgroundColor1 = "FloralWhite";
  }
}</pre></td>
<td><div id = "Example"></div>
</td></tr></table>

<script>
let canvas1, canvas2, backgroundColor1;
function setup() {
  canvas1 = createCanvasClass(180, 170);
  canvas1.parent("Example");
  canvas1.fill(255, 0, 0);
  canvas1.mouseClicked(clicked);
  backgroundColor1 = "FloralWhite";
  canvas2 = createCanvasClass(150, 200);
  canvas2.parent("Example");
  canvas2.stroke(255, 0, 255);
}
function draw() {
  canvas1.background(backgroundColor1);
  canvas1.rect(canvas1.mouseX, canvas1.mouseY, 100 ,80);
  canvas2.background("Khaki");
  canvas2.line(canvas2.mouseX, canvas2.mouseY, 75, 100);
}
function clicked() {
  if (backgroundColor1 == "FloralWhite") {
    backgroundColor1 = "Plum";
  } else {
    backgroundColor1 = "FloralWhite";
  }
}

</script>
<p>Notice that names for canvases and mouse positions are used consistently.
  In regular p5 canvases there are times when a canvas name is required and
  other times when it is not allowed.</p>
<p>Want to be able to follow the mouse even when the mouse is not over the
  canvas?  See <a href = "philExample.html">philExample.html</a>.</p>
<p>A significant problem is related to the fact that p5.js resets some 
  transformations (using resetMatrix) and WEBGL rotations
  every time a new frame is drawn.   Unfortunately I haven't figured
  out how to do either automatically.  It is relatively easy
  to solve problems related to resetMatrix, translate, rotate, and scale but
  I have been unable to solve problems related to WEBGL.  16 methods
  WEBGL methods have been implemented: (plane, box, cylinder, cone,
  torus, sphere, ambientLight, pointLight, specularColor, normalMaterial,
  ambientMaterial,   specularMaterial, shininess, rotateX,
  rotateY, and rotateZ).
  All of these methods work when used in <tt>setup()</tt>.  Implementing them
  was easy. But there is a problem.  The first 9 work nicely
  when used in <tt>draw()</tt> unless the object is put in motion using
  3 rotate methods.
  I am pretty sure that the problem is related to the fact the rotations are
  not reset every time a new frame is drawn. </p>

<p>I am sure that persons who better understand instance mode, nameSpace, 
  <tt>_pInst</tt> and renderer could write better code and solve the problems
  with resetting things with each time <tt>draw()</tt> is executed. There were
  some times I had to make choices about how to implement methods - some of
  those choices are debatable.  Unfortunately, there are probably still some
  coding errors despite a lot of testing.</p> 
<p> CanvasClass actually uses
  instance mode to create the canvas but hides it so users don't need to
  be concerned with it.  Most methods are trivial to implement but a few
  (particularly those that use hidden data) had to be rewritten. </p>
  
<p><a href = "implimentation.html">implementation.html</a> Lists the methods
 and other elements that have been implemented CanvasClass.</p>
<p>Some examples and testing:<br>
<a href = "sketch.html">sketch.html</a> A program to allow drawing  with 
    different shapes that uses several CanvasClass methods.<br>
<a href = "ball.html">ball.html</a> A rewrite of a
     <a href = "https://www.youtube.com/watch?v=fbqboV1iHy0">
    SonnySanberg demo</a> with three bouncing ball using CanvasClass.<br>
<a href = "Birthday.html"> Birthday.html</a> A fun page that uses one
    CanvasClass.</a><br>
<a href = "bezier.html">bezier.html</a> Demo using bezier curves.<br>
<a href = "Enlarge.html">Enlarge.html</a> Allows one to load a large image
   file into one CanvasClass and then look at a enlarged portion of it in a 
  second CanvasClass.<br><br>
<a href = "child.html">child.html</a> Tests child, text, style, id, background, 
  elt, canvas, and fill comparing them to a regular p5.js canvas.<br>
<a href = "colors.html">colors.html</a> Tests several color related methods.<br>
<a href = "colorTest.html">colorTest.html</a> Test several color related
  methods with  emphasis on colorMode, HSL and HSB.<br>
<a href = "CanvasClassTest.html">CanvasClassTest.html</a> Test over 50
  methods using 15 canvases.</br>
<a href = "image.html">image.html</a> Tests image, blend, background(image)
  and pixelDensity<br>
<a href = "domImage.html">domImage.html</a> Tests parent, id, clear,
  text, background, rect, applyMatrix, resetMatrix, image, and imageMode.<br>
<a href = "rotation.html">rotation.pjs</a> Demonstrates successes and failures
  when working with WEBGL and "in-motion" rotations.<br>
<a href = "webgl.html">webgl.html</a> Also demonstrates successes and failures
  when working with WEBGL and "in-motion" rotations.  Tests the several WEBGL
   related methods that have been implemented.<br>
<a href = "ambient.html">ambient.html</a> Tests several material and light
   WEBGL functions.<br>
<a href = "testRotation.html">testRotation.html</a> Illustrates some rotations
   and translations that work.</br>
<a href = "events.html">events.html</a> Tests many events.<br>
<a href= "events2.html">events2.html</a> Illustrates how to use CanvasClass
   events.<br>
<a href = "hideShow.html">hideShow.html</a> Tests resize, hide and show
   demonstrating the CanvasClass option to show the canvas inline.<br>
<a href = "save.html">save.html</a> Tests saveCanvas.<br>
<a href = "TV.html">TV.html</a> There are 4 "TV's" each doing there own
  thing.  It tests image, mouseClicked and keyIsPressed along with several 
  methods.<br>
<a href = "transforms.html">transforms.html</a> Tests resetMatrix, scale,
  rotate, and translate along with several other methods.<br>
<a href = "get.html">get.html</a> Tests <tt>get</tt>. Works correctly with
  2 arguements but not with 0 or 4.<br>
<a href = "getImageFromWebPage.html">getImageFromWebPage.html</a>
  Tests and demonstates 3 ways to load images from the web page.  Loading
  images from the web pages avoids having to preload or use local servers.<br>

</p>

<h3>Known problems:</h3>
<p>Any help in solving these problems would be appreciated.</p>
<ul>
  <li>In a regular p5 canvas, <tt>resetMatrix()</tt> is called every time the
   frame is redrawn.  This does not happen in CanvasClass.  The solution
   is to call <tt>resetMatrix()</tt> at the beginning of <tt>draw()</tt> if 
   <tt>applyMatrix</tt>, <tt>rotate</tt>, <tt>scale</tt>, or <tt>translate</tt>
  are used.</li>
  <li>Rotations don't work in "in-motion" draw()s in the WEBGL mode.</li>
  <li>Some WEBGL materials and lights don't work too well when used in 
     <tt>draw()</tt>.
  <li>In some situations, it is necessary to say can.canvas (or can.elt)
   when referring to the canvas.  Example: see saveCanvas.  (Here
   we are assuming that the canvas is named "can".);</li>
  <li><tt>get()</tt> and <tt>get(x, y, w, h)</tt>have problems even though 
   <tt>get(x, y)</tt> works OK.</li>
</ul>
<p>If you have an application you would like to share, have questions, 
   suggestions, or comments, please let me know.
  <a href="mailto:brinkje@plu.edu">
   brinkje@plu.edu</a></p>
<p>The <a href = "CanvasClass.pjs">CanvasClass.pjs</a> file.<br>
<a href = "CanvasClass.zip">CanvasClass.zip</a> a zip file containing all the files listed above.</p>
</p>

<p>James Brink, 8/29/2020</p>
<div> 
<?php
 $handle = fopen("counter.txt", "r");
 if(!$handle){
   echo "could not open the file"; }
 else  {
   $counter=(int )fread($handle,20);
   fclose($handle); $counter++;
   echo"This page has been viewed " . $counter . " times";
   $handle= fopen("counter.txt", "w" ) ;
   fwrite($handle,$counter) ;
   fclose ($handle) ; 
  } 
?>
</div>
</body>
</html>
